<?php
namespace RoboTheme\inc\elementor\Modules\Woocommerce\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use RoboTheme\inc\elementor\Modules\Woocommerce\Module;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RBT_Mini_Cart extends Widget_Base {

	public function get_name() {
		return 'rbt-mini-cart';
	}

	public function get_title() {
		return esc_html__( 'Mini Cart', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-cart';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'mini cart', 'cart', 'wc', 'woocommerce', 'add to cart' ];
	}

	public function get_script_depends() {
		return [ 'rbt-woocommerce' ];
	}

	public function get_style_depends() {
		return [ 'rbt-woocommerce' ];
	}

	protected function register_controls() {
		$this->register_content_mini_cart_controls();
		$this->register_content_offcanvas_controls();
		$this->register_style_mini_cart_controls();
		$this->register_style_offcanvas_controls();
		$this->register_content_close_button_controls();
	}

	protected function register_content_mini_cart_controls() {

		$this->start_controls_section(
			'section_content_mini_cart',
			[
				'label' => esc_html__( 'Mini Cart', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_price_amount',
			[
				'label'   => esc_html__( 'Show Price Amount', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'prefix_class' => 'wc-cart-price--',
			]
		);

		$this->add_control(
			'show_cart_icon',
			[
				'label'   => esc_html__( 'Show Cart Icon', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'prefix_class' => 'wc-cart-icon--',
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => __( 'Icon', TEXT_DOMAIN ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'cart-light'    => __( 'Cart', TEXT_DOMAIN ) . ' ' . __( 'Light', TEXT_DOMAIN ),
					'cart-medium'   => __( 'Cart', TEXT_DOMAIN ) . ' ' . __( 'Medium', TEXT_DOMAIN ),
					'cart-solid'    => __( 'Cart', TEXT_DOMAIN ) . ' ' . __( 'Solid', TEXT_DOMAIN ),
					'basket-light'  => __( 'Basket', TEXT_DOMAIN ) . ' ' . __( 'Light', TEXT_DOMAIN ),
					'basket-medium' => __( 'Basket', TEXT_DOMAIN ) . ' ' . __( 'Medium', TEXT_DOMAIN ),
					'basket-solid'  => __( 'Basket', TEXT_DOMAIN ) . ' ' . __( 'Solid', TEXT_DOMAIN ),
					'bag-light'     => __( 'Bag', TEXT_DOMAIN ) . ' ' . __( 'Light', TEXT_DOMAIN ),
					'bag-medium'    => __( 'Bag', TEXT_DOMAIN ) . ' ' . __( 'Medium', TEXT_DOMAIN ),
					'bag-solid'     => __( 'Bag', TEXT_DOMAIN ) . ' ' . __( 'Solid', TEXT_DOMAIN ),
				],
				'default' => 'cart-medium',
				'prefix_class' => 'wc-cart-icon--',
				'condition' => [
					'show_cart_icon' => ['yes'],
				]
			]
		);

		$this->add_control(
			'show_cart_badge',
			[
				'label'   => esc_html__( 'Show Badge', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'prefix_class' => 'wc-cart-badge--',
			]
		);

		$this->add_responsive_control(
			'mini_cart_align',
			[
				'label'   => esc_html__( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_html__( 'Left', TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-right',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'mini_cart_icon_indent',
			[
				'label'   => esc_html__( 'Icon Spacing', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 8,
				],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_content_offcanvas_controls() {

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Offcanvas', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'custom_widget_cart_title',
			[
				'label'   => esc_html__( 'Cart Title', TEXT_DOMAIN ),
				'type'    => Controls_Manager::TEXT,
				'dynamic' => [ 'active' => true ],
				'default' => esc_html__( 'Shopping Cart', TEXT_DOMAIN ),
				'separator' => 'after',
			]
		);

		$this->add_control(
			'offcanvas_close_button',
			[
				'label'   => esc_html__( 'Close Button', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_mini_cart_controls() {

		$this->start_controls_section(
			'section_style_mini_cart_content',
			[
				'label' => esc_html__( 'Mini Cart', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'mini_cart_price_amount_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-cart-button-text .rbt-mini-cart-price-amount *' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'mini_cart_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'mini_cart_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'selector'    => '{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button',
			]
		);

		$this->add_control(
			'mini_cart_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'mini_cart_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'price_amount_typography',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-cart-button-text',
			]
		);

		$this->add_control(
			'mini_cart_icon_style',
			[
				'label' 	=> __( 'Cart Icon', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'mini_cart_icon_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon .rbt-cart-icon i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'mini_cart_icon_typography',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon .rbt-cart-icon i',
			]
		);
		
		$this->add_control(
			'mini_cart_badge_style',
			[
				'label' 	=> __( 'Cart Badge', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'top_cart_badge',
			[
				'label' => esc_html__( 'Top', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon .rbt-cart-badge' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'bot_cart_badge',
			[
				'label' => esc_html__( 'Bottom', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon .rbt-cart-badge' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'mini_cart_badge_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon .rbt-cart-badge' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'mini_cart_badge_background_color',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon .rbt-cart-badge' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'cart_badge_typography',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon .rbt-cart-badge',
			]
		);

        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow_badge',
				'label' => esc_html__( 'Box Shadow', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rbt-mini-cart-wrapper .rbt-mini-cart-button-icon .rbt-cart-badge',
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_offcanvas_controls() {

		$this->start_controls_section(
			'section_style_offcanvas_content',
			[
				'label' => esc_html__( 'Offcanvas', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_style_offcanvas_content' );

		$this->start_controls_tab(
			'tab_style_product_cart',
			[
				'label' => esc_html__( 'Product List', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'product_cart_main_title_color',
			[
				'label'     => esc_html__( 'Cart Title Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-offcanvas .rbt-widget-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'product_cart_main_title_border_color',
			[
				'label'     => esc_html__( 'Cart Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-offcanvas .rbt-widget-title' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'product_cart_main_title_typography',
				'selector' => '{{WRAPPER}} .rbt-offcanvas .rbt-widget-title',
			]
		);

		$this->add_control(
			'product_cart_style',
			[
				'label' 	=> __( 'Product Cart', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'product_cart_title_color',
			[
				'label'     => esc_html__( 'Title Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-name a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'product_cart_title_hover_color',
			[
				'label'     => esc_html__( 'Title Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-name a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'product_cart_title_typography',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-name a',
			]
		);

		$this->add_control(
			'product_cart_item_border_color',
			[
				'label'     => esc_html__( 'Item Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item' => 'border-color: {{VALUE}};',
				],
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'product_cart_quantity_price_style',
			[
				'label' 	=> __( 'Price', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'product_cart_quantity_color',
			[
				'label'     => esc_html__( 'Quantity Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-price' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'product_cart_price_color',
			[
				'label'     => esc_html__( 'Amount Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .widget_shopping_cart_content .amount' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'product_cart_price_typography',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-price',
			]
		);

		$this->add_control(
			'product_cart_image_style',
			[
				'label' 	=> __( 'Image', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'product_cart_image_border',
				'label'       => esc_html__( 'Image Border', TEXT_DOMAIN ),
				'selector'    => '{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-thumbnail img',
			]
		);

		$this->add_responsive_control(
			'product_cart_image_radius',
			[
				'label'      => esc_html__( 'Image Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
		);

		$this->add_control(
			'product_cart_subtotal_style',
			[
				'label' 	=> __( 'Subtotal', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'product_cart_subtotal_color',
			[
				'label'     => esc_html__( 'Subtotal Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-subtotal' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'product_cart_subtotal_tax_color',
			[
				'label'     => esc_html__( 'Tax Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-subtotal small' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'product_cart_subtotal_typography',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-subtotal',
			]
		);

		$this->add_control(
			'product_cart_viewcart_button_style',
			[
				'label' 	=> __( 'View Cart Button', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'pc_viewcart_text_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart .rbt-button-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_viewcart_button_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart:hover .rbt-button-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_viewcart_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_viewcart_background_hover_color',
			[
				'label'     => esc_html__( 'Hover Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'pc_viewcart_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'selector'    => '{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart',
			]
		);

		$this->add_control(
			'pc_viewcart_hover_border_color',
			[
				'label'     => esc_html__( 'Hover Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'pc_viewcart_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_viewcart_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'pc_viewcart_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pc_viewcart_shadow',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'pc_viewcart_typography',
				'label'     => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector'  => '{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-view-cart .rbt-button-text',
			]
		);

		$this->add_control(
			'product_cart_checkout_button_style',
			[
				'label' 	=> __( 'Checkout Button', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'pc_checkout_text_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout .rbt-button-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_checkout_button_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout:hover .rbt-button-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_checkout_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_checkout_background_hover_color',
			[
				'label'     => esc_html__( 'Hover Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'pc_checkout_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'selector'    => '{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout',
			]
		);

		$this->add_control(
			'pc_checkout_hover_border_color',
			[
				'label'     => esc_html__( 'Hover Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'pc_checkout_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_checkout_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'pc_checkout_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pc_checkout_shadow',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'pc_checkout_typography',
				'label'     => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector'  => '{{WRAPPER}} .rbt-mini-cart-footer-buttons .rbt-button-checkout .rbt-button-text',
			]
		);

		$this->add_control(
			'product_cart_remove_button_style',
			[
				'label' 	=> __( 'Product Remove Button', TEXT_DOMAIN ),
				'type' 		=> Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'pc_remove_text_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a svg *' => 'stroke: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_remove_button_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a:hover svg *' => 'stroke: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_remove_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_remove_background_hover_color',
			[
				'label'     => esc_html__( 'Hover Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'pc_remove_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'selector'    => '{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a',
			]
		);

		$this->add_control(
			'pc_remove_hover_border_color',
			[
				'label'     => esc_html__( 'Hover Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'pc_remove_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pc_remove_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'pc_remove_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pc_remove_shadow',
				'selector' => '{{WRAPPER}} .rbt-mini-cart-product-item .rbt-mini-cart-product-remove a',
			]
		);

		$this->end_controls_tab();


		$this->start_controls_tab(
			'tab_style_offcanvas_content',
			[
				'label' => esc_html__( 'Offcanvas', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'offcanvas_content_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'#rbt-offcanvas-{{ID}}.rbt-offcanvas .rbt-offcanvas-bar' => 'background-color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'      => 'offcanvas_content_shadow',
				'selector'  => '#rbt-offcanvas-{{ID}}.rbt-offcanvas > div',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'offcanvas_content_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'#rbt-offcanvas-{{ID}}.rbt-offcanvas .rbt-offcanvas-bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'offcanvas_margin',
			[
				'label'      => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'#rbt-offcanvas-{{ID}}.rbt-offcanvas .rbt-offcanvas-bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

	}

	protected function register_content_close_button_controls() {

		$this->start_controls_section(
			'section_style_close_button',
			[
				'label'     => esc_html__( 'Offcanvas Close Button', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'offcanvas_close_button' => 'yes'
				]
			]
		);

		$this->start_controls_tabs( 'tabs_close_button_style' );

		$this->start_controls_tab(
			'tab_close_button_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'close_button_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'.rbt-offcanvas .rbt-offcanvas-close' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'close_button_bg',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'.rbt-offcanvas .rbt-offcanvas-close' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'      => 'close_button_shadow',
				'selector'  => '.rbt-offcanvas .rbt-offcanvas-close',
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'close_button_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '.rbt-offcanvas .rbt-offcanvas-close',
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'close_button_radius',
			[
				'label'      => esc_html__( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'.rbt-offcanvas .rbt-offcanvas-close' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'close_button_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'.rbt-offcanvas .rbt-offcanvas-close' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_close_button_hover',
			[
				'label' => esc_html__( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'close_button_hover_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'.rbt-offcanvas .rbt-offcanvas-close:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'close_button_hover_bg',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'.rbt-offcanvas .rbt-offcanvas-close:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'close_button_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'.rbt-offcanvas .rbt-offcanvas-close:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

	}






















	protected function render_button() {
		$settings = $this->get_settings_for_display();
		$id       = 'rbt-offcanvas-' . $this->get_id();

		if ( null === WC()->cart ) {
			return;
		}

		global $woocommerce;

		$this->add_render_attribute( 'button', 'class', ['rbt-offcanvas-button', 'rbt-mini-cart-button'] );
		if ( ! empty( $settings['size'] ) ) {
			$this->add_render_attribute( 'button', 'class', 'elementor-size-' . $settings['size'] );
		}
		$this->add_render_attribute( 'button', 'rbt-toggle', 'target: #' . esc_attr($id) );
		$this->add_render_attribute( 'button', 'href', '#' );

		$product_count = WC()->cart->get_cart_contents_count();
		?> 

		<div class="rbt-mini-cart-wrapper">

			<a <?php echo $this->get_render_attribute_string( 'button' ); ?> >

				<span class="rbt-mini-cart-inner">
					<span class="rbt-cart-button-text">
						<span class="rbt-mini-cart-price-amount">
	                        <?php echo WC()->cart->get_cart_subtotal(); ?>
						</span>
					</span>

					<span class="rbt-mini-cart-button-icon">

	                    <?php if ( $product_count != 0 ) : ?>
	                        <span class="rbt-cart-badge"><?php echo esc_html($product_count); ?></span>
	                    <?php endif; ?>

						<span class="rbt-cart-icon">
							<i class="eicon" aria-hidden="true"></i>
						</span>

					</span>
				</span>

			</a>

		</div>

		<?php
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$id       = 'rbt-offcanvas-' . $this->get_id();

		global $woocommerce;

		$this->add_render_attribute( 'offcanvas', 'class', 'rbt-offcanvas' );
		$this->add_render_attribute( 'offcanvas', 'id', $id );
        $this->add_render_attribute(
        	[
        		'offcanvas' => [
        			'data-settings' => [
        				wp_json_encode(array_filter([
							'id'      =>  $id,
        		        ]))
        			]
        		]
        	]
        );

		$this->render_button(); ?>

	    <div <?php echo $this->get_render_attribute_string( 'offcanvas' ); ?>>

	        <div class="rbt-offcanvas-bar rbt-text-left">

				<div class="basket__header">
					<div class="rbt-widget-title">
						<?php echo wp_kses_post($settings['custom_widget_cart_title']); ?>
					</div>
					<?php if ($settings['offcanvas_close_button']) : ?>
						<div class="rbt-offcanvas-close">
							<div class="eicon-close"></div>
						</div>
					<?php endif; ?>
				</div>

				<div class="widget_shopping_cart_content"></div>

	        </div>

	    </div>

		<?php
	}




















	
}