<?php

namespace RoboTheme\inc\elementor\Modules\Title\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RBT_Title extends Widget_Base {

	public function get_name(){
		return 'rbt-title';
	}

	public function get_title(){
		return __( 'Title', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-post-title';
	}

    public function get_keywords() {
        return [ 'title', 'single' ];
    }

	public function get_categories() {
        return [ RBT_CAT ];
    }
   
    protected function register_controls() {
        $this->start_controls_section(
            'tags_setting',
            [
                'label' => __( 'Setting', TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __( 'Title Tag', TEXT_DOMAIN ),
                'type' => Controls_Manager::SELECT,
                'default' => 'h1',
                'options' => rbt_title_tags(),
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label' => __( 'Alignment', TEXT_DOMAIN ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'right',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'label' => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();
        $title_tag = $settings['title_tag'];
        $text_align = $settings['text_align'];

        echo "<$title_tag class='title'>"; 
            echo RBT_Seo_Title(); 
        echo "</$title_tag>";
    }

}