<?php
namespace RoboTheme\inc\elementor\Modules\Navbar\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes;
use RoboTheme\inc\elementor\Modules\Navbar\rbt_main_nav_walker;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class RBT_Navbar extends Widget_Base {

	public function get_name() {
		return 'rbt-navbar';
	}

	public function get_title() {
		return esc_html__( 'Navbar', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-nav-menu';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'navbar', 'menu' ];
	}

	public function get_style_depends() {
		return [ 'rbt-navbar' ];
	}

    public function get_script_depends() {
        return ['rbt-navbar'];
    }
    
    protected function rbt_get_menu() {
        $menus = wp_get_nav_menus();
        $items = ['0' => __( 'Select Menu', TEXT_DOMAIN ) ];
        foreach ( $menus as $menu ) {
            $items[ $menu->slug ] = $menu->name;
        }
        return $items;
    }

    protected function register_controls() {
        // content //
        $this->register_controls_content_navbar();
        $this->register_controls_content_sub_menu();
        $this->register_controls_content_arrows();
        // style //
        $this->register_controls_style_navbar();
        $this->register_controls_style_subMenu();
        // responsive //
        $this->register_controls_style_icon_bars_rsp();
        $this->register_controls_style_navbar_rsp();
        $this->register_controls_style_sub_menu_rsp();
        $this->register_controls_style_arrow_rsp();
        $this->register_controls_style_img_rsp();
    }

    // content //
    protected function register_controls_content_navbar() {
        $this->start_controls_section(
            'section_content_navbar',
            [
                'label' => __( 'Navbar', TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'navbar',
            [
                'label'   => __( 'Select Menu', TEXT_DOMAIN ),
                'type'    => Controls_Manager::SELECT,
                'options' => $this->rbt_get_menu(),
                'default' => 0,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'   => __( 'Alignment', TEXT_DOMAIN ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon'  => 'eicon-h-align-center',
                    ],
                    'flex-end'  => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .links' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'menu_spacing',
            [
                'label' => __( 'Gap', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 25,
                    ],
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .links > li' => 'margin: 0 {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navbar_height',
            [
                'label' => __( 'Menu Height', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 150,
                    ],
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .links > li > a' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navbar_margin',
            [
                'label'      => __( 'Margin', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .links' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navbar_links_padding',
            [
                'label'      => __( 'Padding', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default'    => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .links > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'navbar_links_typography',
                'label'    => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .links > li > a',
            ]
        );

        $this->end_controls_section();
    }

    protected function register_controls_content_sub_menu() {
        $this->start_controls_section(
            'section_content_sub_menu',
            [
                'label' => __( 'Sub Menu', TEXT_DOMAIN ),
            ]
        );

        $this->add_responsive_control(
            'subMenu_radius',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .links .sub-menu > li:first-child' => 'border-top-left-radius: {{SIZE}}{{UNIT}};border-top-right-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .links .sub-menu > li:last-child' => 'border-bottom-left-radius: {{SIZE}}{{UNIT}};border-bottom-right-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'submenu_width',
            [
                'label' => __( 'Width', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 400,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 250,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .links .sub-menu' => 'min-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'submenu_offset',
			[
				'label' => __( 'Offset SubMenu 1', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 35,
				],
				'selectors' => [
                    '{{WRAPPER}} .links li.menu-item-has-children > .sub-menu' => 'padding-top: {{SIZE}}px;',
                    '{{WRAPPER}} .links li.menu-item-has-children > .sub-menu .sub-menu' => 'padding-top: 0;',
				],
			]
        );

        $this->add_control(
			'submenu_submenu_offset',
			[
				'label' => __( 'Offset SubMenu 2', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 20,
				],
				'selectors' => [
                    '{{WRAPPER}} .sub-menu li.menu-item-has-children > .sub-menu' => 'padding-left: {{SIZE}}px;',
                    'body.rtl {{WRAPPER}} .sub-menu li.menu-item-has-children > .sub-menu' => 'padding-left: 0;padding-right: {{SIZE}}px;',
				],
			]
		);
		
        $this->add_responsive_control(
            'submenu_links_padding',
            [
                'label'      => __( 'Links Padding', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'default'    => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                    'unit' => 'px',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu) > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'submenu_padding',
            [
                'label'      => __( 'Padding', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'allowed_dimensions' => ['right','left'],
                'default'    => [
                    'right' => '20',
                    'left' => '20',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .links .sub-menu li' => 'padding:0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		
		$this->add_responsive_control(
            'dropdown_margin',
            [
                'label'      => __( 'Margin', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'subMenu_typography',
                'label'    => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu) > a',
            ]
        );

        $this->end_controls_section();
    }

    protected function register_controls_content_arrows() {
        $this->start_controls_section(
            'section_content_arrow',
            [
                'label' => __( 'Arrow', TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
			'heading_arrow_navbar',
			[
				'label' => esc_html__( 'Arrow Navbar', TEXT_DOMAIN ),
				'type' => Controls_Manager::HEADING,
			]
		);

        $this->add_responsive_control(
            'size_arrow_navbar',
            [
                'label' => __( 'Size', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 25,
                        ],
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .links > li.menu-item-has-children:after' => 'font-size: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_control(
			'select_arrow_navbar',
			[
				'label' => esc_html__( 'Select Arrow', TEXT_DOMAIN ),
				'type' => Controls_Manager::SELECT,
                'default' => 'e87e',
				'options' => [
					'e87e'  => esc_html__( 'Plus', TEXT_DOMAIN ),
				],
                'selectors' => [
                    '{{WRAPPER}} li.menu-item-has-children:after' => 'content: "\{{VALUE}}";font-family:eicons;',
                ],
			]
		);

        $this->add_responsive_control(
            'space_arrow_navbar',
            [
                'label'      => __( 'Offset', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'left' ],
                'default'    => [
                    'left' => '8',
                    'top' => '3',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .links > li.menu-item-has-children:after' => 'top: {{TOP}}px; left: {{LEFT}}px;',
                ],
            ]
        );

        $this->add_control(
            'heading_arrow_submenu',
            [
                'label' => __( 'Arrow Sub Menu', TEXT_DOMAIN ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'size_arrow_submenu',
            [
                'label' => __( 'Size', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .links .sub-menu > li.menu-item-has-children:after' => 'font-size: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'space_arrow_submenu',
            [
                'label'      => __( 'Offset', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'right' ],
                'default'    => [
                    'top' => '9',
                    'right' => '12',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .links .sub-menu > li.menu-item-has-children:after' => 'top: {{TOP}}px; left:{{RIGHT}}px;',
                ],
            ]
        );

        $this->end_controls_section();
    }

    // Style //
    protected function register_controls_style_navbar() {
        $this->start_controls_section(
            'section_style_navbar',
            [
                'label' => __( 'Navbar', TEXT_DOMAIN ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


























        // nornal //
        $this->start_controls_tabs( 'navbar_links_styles' );
        $this->start_controls_tab( 'navbar_links_normal', [ 'label' => __( 'Normal', TEXT_DOMAIN ) ] );
		
		$this->add_control(
            'icon_link_color',
            [
                'label'     => __( 'Color Icon', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666',
                'selectors' => [
                    '{{WRAPPER}} #moz-links > li > a > i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navbar_links_color',
            [
                'label'     => __( 'Links Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#3c4354',
                'selectors' => [
                    '{{WRAPPER}} .links > li > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navbar_links_bg',
            [
                'label'     => __( 'Links Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links > li' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_navbar_color',
            [
                'label'     => __( 'Arrow Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666',
                'selectors' => [
                    '{{WRAPPER}} .links li.menu-item-has-children::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'navbar_border',
                'label'    => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .links > li',
            ]
        );

        $this->add_responsive_control(
            'navbar_border_radius',
            [
                'label'      => __( 'Border Radius', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .links > li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

































        // hover //
        $this->start_controls_tab( 'navbar_links_hover', [ 'label' => __( 'Hover', TEXT_DOMAIN ) ] );
		
		$this->add_control(
            'icon_link_color_hover',
            [
                'label'     => __( 'Color Icon', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666',
                'selectors' => [
                    '{{WRAPPER}} #moz-links > li:hover > a > i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navbar_links_color_hover',
            [
                'label'     => __( 'Links Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#eee',
                'selectors' => [
                    '{{WRAPPER}} .links > li:hover > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navbar_links_bg_hover',
            [
                'label'     => __( 'Links Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666',
                'selectors' => [
                    '{{WRAPPER}} .links > li:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_navbar_color_hover',
            [
                'label'     => __( 'Arrow Navbar Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#eee',
                'selectors' => [
                    '{{WRAPPER}} .links li.menu-item-has-children:hover:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navbar_border_color_hover',
            [
                'label'     => __( 'Border Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links > li:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navbar_border_radius_hover',
            [
                'label'      => __( 'Border Radius', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .links > li:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();





























        // active //
        $this->start_controls_tab( 'navbar_links_active', [ 'label' => __( 'Active', TEXT_DOMAIN ) ] );
		
		$this->add_control(
            'icon_link_color_active',
            [
                'label'     => __( 'Color Icon', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666',
                'selectors' => [
                    '{{WRAPPER}} #moz-links > li.current-menu-item > a > i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navbar_links_color_active',
            [
                'label'     => __( 'Links Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links > li.current-menu-item > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navbar_links_bg_active',
            [
                'label'     => __( 'Links Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links > li.current-menu-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_navbar_color_active',
            [
                'label'     => __( 'Arrow Navbar Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links li.menu-item-has-children.current-menu-item:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navbar_border_color_active',
            [
                'label'     => __( 'Border Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links > li.current-menu-item' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navbar_links_border_radius_active',
            [
                'label'      => __( 'Border Radius', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .links > li.current-menu-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function register_controls_style_subMenu() {
        $this->start_controls_section(
            'section_style_subMenu',
            [
                'label' => __( 'Sub Menu', TEXT_DOMAIN ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // Normal //
        $this->start_controls_tabs( 'subMenu_links_styles' );
        $this->start_controls_tab( 'subMenu_links_normal', [ 'label' => __( 'Normal', TEXT_DOMAIN ) ] );

        $this->add_control(
            'subMenu_links_color',
            [
                'label'     => __( 'Links Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#eee',
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu) > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subMenu_links_bg',
            [
                'label'     => __( 'Links Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#999',
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_subMenu_color',
            [
                'label'     => __( 'Arrow SubMenu Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#eee',
                'selectors' => [
                    '{{WRAPPER}} .links ul li.menu-item-has-children:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'subMenu_border_radius',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'subMenu_border',
                'label'    => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .links .sub-menu li a:not(.mega-menu)',
            ]
        );

        $this->end_controls_tab();











        // hover //
        $this->start_controls_tab( 'subMenu_links_hover', [ 'label' => __( 'Hover', TEXT_DOMAIN ) ] );

        $this->add_control(
            'subMenu_links_color_hover',
            [
                'label'     => __( 'Links Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu):hover > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subMenu_links_bg_hover',
            [
                'label'     => __( 'Links Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666',
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu):hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_subMenu_color_hover',
            [
                'label'     => __( 'Arrow SubMenu Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li.menu-item-has-children:hover:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subMenu_border_color_hover',
            [
                'label'     => __( 'Border Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu):hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );
    
        $this->add_responsive_control(
            'subMenu_border_radius_hover',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li:not(.mega-menu):hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_tab();

























        // Active //
        $this->start_controls_tab( 'subMenu_links_active', [ 'label' => __( 'Active', TEXT_DOMAIN ) ] );

        $this->add_control(
            'subMenu_links_color_active',
            [
                'label'     => __( 'Links Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li.current-menu-item > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subMenu_links_bg_active',
            [
                'label'     => __( 'Links Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li.current-menu-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_subMenu_color_active',
            [
                'label'     => __( 'Arrow SubMenu Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li.menu-item-has-children.current-menu-item:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subMenu_border_color_active',
            [
                'label'     => __( 'Border Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li.current-menu-item' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'subMenu_border_radius_active',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .links .sub-menu > li.current-menu-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    // Responsive //
    protected function register_controls_style_icon_bars_rsp() {
        $this->start_controls_section(
            'section_style_icon_bars_rsp',
            [
                'label' => __( 'Icon Bars - Responsive', TEXT_DOMAIN ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'icon_bars_styles' );
        $this->start_controls_tab( 'icon_open', [ 'label' => __( 'Open', TEXT_DOMAIN ) ] );

        $this->add_control(
            'responsive_icon_align',
            [
                'label'   => __( 'Icon Alignment', TEXT_DOMAIN ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon'  => 'eicon-h-align-center',
                    ],
                    'flex-end'  => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .main-bar' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_color',
            [
                'label'     => __( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#eee',
                'selectors' => [
                    '{{WRAPPER}} .bars' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_background',
            [
                'label'     => __( 'Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666',
                'selectors' => [
                    '{{WRAPPER}} .bars' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_width',
            [
                'label' => __( 'Size', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'em' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 'em',
                    'size' => 1.6,
                ],
                'selectors' => [
                    '{{WRAPPER}} .bars' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_border_radius',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .bars' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_padding',
            [
                'label' => __( 'Padding', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .bars' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'rsp_border_color',
                'label'    => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .bars',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab( 'icon_close', [ 'label' => __( 'Close', TEXT_DOMAIN ) ] );

        $this->add_control(
            'rsp_icon_open_color',
            [
                'label'     => __( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666',
                'selectors' => [
                    '{{WRAPPER}} .eicon-close' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_open_bg',
            [
                'label'     => __( 'Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#eee',
                'selectors' => [
                    '{{WRAPPER}} .eicon-close' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_open_width',
            [
                'label' => __( 'Size', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'em' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 'em',
                    'size' => 1.6,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eicon-close' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_open_border_radius',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .eicon-close' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_open_padding',
            [
                'label' => __( 'Padding', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eicon-close' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_icon_open_margin',
            [
                'label' => __( 'Margin', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top' => '15',
                    'right' => '15',
                    'bottom' => '15',
                    'left' => '15',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eicon-close' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'rsp_border_icon_open',
                'label'    => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .eicon-close',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function register_controls_style_navbar_rsp() {
        $this->start_controls_section(
            'section_style_navbar_rsp',
            [
                'label' => __( 'Navbar - Responsive', TEXT_DOMAIN ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'rsp_navbar_links_color',
            [
                'label'     => __( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .open-menu .links li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_navbar_background',
            [
                'label'     => __( 'Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333',
                'selectors' => [
                    '{{WRAPPER}} .open-menu .rbt-navmenu' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_navbar_background_overlay',
            [
                'label'     => __( 'Background Overlay', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333',
                'selectors' => [
                    '{{WRAPPER}} .open-menu .overlay' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_navbar_background_section',
            [
                'label'     => __( 'Background section', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333',
                'selectors' => [
                    '{{WRAPPER}} .open-menu .nav-panel' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'rsp_navbar_border',
                'label'    => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .open-menu .links li',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'rsp_navbar_typography',
                'label'    => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .open-menu .links li a',
            ]
        );
        $this->add_control(
            'rsp_navbar_padding',
            [
                'label'      => __( 'Padding', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default'    => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .open-menu .links .sub-menu > li:not(.mega-menu) > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'rsp_navbar_margin',
            [
                'label'      => __( 'Margin', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .open-menu .links > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_controls_style_sub_menu_rsp() {
        $this->start_controls_section(
            'section_style_subMenu_rsp',
            [
                'label' => __( 'Sub Menu - Responsive', TEXT_DOMAIN ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'rsp_sub_menu_links_color',
            [
                'label'     => __( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .open-menu .links .sub-menu > li > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'rsp_sub_menu_background',
            [
                'label'     => __( 'Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#000',
                'selectors' => [
                    '{{WRAPPER}} .open-menu .links .sub-menu > li' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'rsp_sub_menu_border',
                'label'    => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .open-menu .links .sub-menu',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'rsp_sub_menu_typography',
                'label'    => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .open-menu .links .sub-menu > li > a',
            ]
        );
        $this->add_control(
            'rsp_sub_menu_padding',
            [
                'label'      => __( 'Padding', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default'    => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .open-menu .links .sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
            'rsp_sub_menu_margin',
            [
                'label'      => __( 'Margin', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .open-menu .links .sub-menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_controls_style_arrow_rsp() {
        $this->start_controls_section(
            'section_style_arrow_rsp',
            [
                'label' => __( 'Arrow - Responsive', TEXT_DOMAIN ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'arrow_size_rsp',
            [
                'label' => __( 'Size', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 25,
                        ],
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .open-menu .links li.menu-item-has-children:after' => 'font-size: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_control(
            'arrow_color_rsp',
            [
                'label'     => __( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .open-menu .links li.menu-item-has-children:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_rsp',
            [
                'label'     => __( 'Background', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .open-menu .links li.menu-item-has-children:after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_space_rsp',
            [
                'label'      => __( 'Padding', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                // 'allowed_dimensions' => [ 'top', 'left' ],
                'size_units' => [ 'px', '%' ],
                // 'default'    => [
                //     'left' => '0',
                //     'top' => '0',
                //     'unit' => 'px',
                //     'isLinked' => false,
                // ],
                'selectors'  => [
                    '{{WRAPPER}} .open-menu .links > li.menu-item-has-children:after' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'space_arrow_rsp',
            [
                'label'      => __( 'Offset', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'left' ],
                'default'    => [
                    'left' => '0',
                    'top' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .open-menu .links > li.menu-item-has-children:after' => 'top: {{TOP}}px !important; left: {{LEFT}}px !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'rsp_arrow_border',
                'label'    => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .open-menu .links li.menu-item-has-children:after',
            ]
        );

        $this->end_controls_section();
    }

    protected function register_controls_style_img_rsp() {
        $this->start_controls_section(
            'section_style_img_rsp',
            [
                'label' => __( 'Image - Responsive', TEXT_DOMAIN ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'img_navbar_rsp',
            [
                'label' => esc_html__( 'Choose Image', TEXT_DOMAIN ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_responsive_control(
            'img_width_rsp',
            [
                'label' => __( 'Width', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'size' => 100
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-navmenu .nav-panel img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_height_rsp',
            [
                'label' => __( 'Height', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'size_units' => [ '%' ],
                'range' => [
                    'range' => [
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-navmenu .nav-panel img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'img_margin_rsp',
            [
                'label' => __( 'Margin', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top' => '15',
                    'right' => '15',
                    'bottom' => '15',
                    'left' => '15',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-navmenu .nav-panel img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings();
        $id = 'rbt-navbar-' . $this->get_id();
        $nav_menu = ! empty( $settings['navbar'] ) ? wp_get_nav_menu_object( $settings['navbar'] ) : false;

        if ( ! $nav_menu ) {
            return;
        }

        $nav_menu_args = array(
            'fallback_cb'    => false,
            'container'      => false,
            'menu_id'        => 'moz-links',
            'menu_class'     => 'links flex',
            'theme_location' => 'default_navmenu', // creating a fake location for better functional control
            'menu'           => $nav_menu,
            'echo'           => true,
            'depth'          => 0,
            'walker'		 => new rbt_main_nav_walker(),
        );
        ?>

        <!-- icon bars -->
        <div class="flex main-bar">
            <div class="bars"></div>
        </div>

        <!-- menu -->
        <div class="rbt-navbar-menu">

            <div class="overlay"></div>

            <div id="<?php echo esc_attr($id); ?>" class="rbt-navmenu">

                <div class='nav-panel'>
                    <?php echo '<img src="' . $settings['img_navbar_rsp']['url'] . '">'; ?>
                    <div class="eicon-close"></div>
                </div>

                <nav class="nav-links">
                    <?php wp_nav_menu( apply_filters( 'widget_nav_menu_args', $nav_menu_args, $nav_menu, $settings ) ); ?>
                </nav>

            </div>

        </div>
        <?php
    }
}