<?php
namespace RoboTheme\inc\elementor\Modules\LogoCarousel\Widgets;

use Elementor\Widget_Base;
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class RBT_Logo_Carousel extends Widget_Base {

	public function get_name() {
		return 'rbt-logo-carousel';
	}

	public function get_title() {
		return esc_html__( 'Logo Carousel', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-logo';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'logo', 'carousel', 'brand'];
	}

	public function get_style_depends() {
		return [ 'rbt-logo-carousel' ];
    }
    
	public function get_script_depends() {
		return [ 'rbt-logo-carousel' ];
	}

	protected function register_controls(){
		$this->register_layout_controls();
		$this->register_sliders_controls();
		$this->register_style_slider_controls();
		$this->register_navigation_controls();
		$this->register_carousel_settings_controls();
		$this->register_style_img_controls();
		$this->register_navigation_style_controls('panel-slider');
	}

    // content //
	protected function register_layout_controls() {

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__('Layout', TEXT_DOMAIN),
			]
		);

		$this->add_responsive_control(
			'columns',
			[
				'label'          => esc_html__('Columns', TEXT_DOMAIN),
				'type'           => Controls_Manager::SELECT,
				'default'        => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options'        => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'frontend_available' => true,
			]
		);

		$this->add_responsive_control(
			'column_space',
			[
				'label' => esc_html__('Column Space', TEXT_DOMAIN),
				'type'  => Controls_Manager::SLIDER,
			]
		);

		$this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );

		$this->end_controls_section();

	}

	protected function register_sliders_controls() {

		$this->start_controls_section(
			'section_content_sliders',
			[
				'label' => esc_html__('Sliders', TEXT_DOMAIN),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			[
				'label'       => __( 'Logo Image', TEXT_DOMAIN ),
				'type'        => Controls_Manager::MEDIA,
				'default'     => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
            'link',
            [
                'label' => __('Website Url', TEXT_DOMAIN),
                'type' => Controls_Manager::URL,
                'show_external' => false,
                'label_block' => false,
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __('Brand Name', TEXT_DOMAIN),
                'type' => Controls_Manager::TEXT,
                'default' => __('Brand Name', TEXT_DOMAIN),
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => __('Description', TEXT_DOMAIN),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Brand Short Description Type Here.', TEXT_DOMAIN),
            ]
        );

        $repeater->add_control(
            'logo_tooltip',
            [
                'label'   => __( 'Tooltip', TEXT_DOMAIN ),
                'type'    => Controls_Manager::SWITCHER,
            ]
        );

        $repeater->add_control(
            'logo_tooltip_placement',						
            [
                'label'   => esc_html__( 'Placement', TEXT_DOMAIN ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'top',
                'options' => [
                    'top-start'    => esc_html__( 'Top Left', TEXT_DOMAIN ),
                    'top'          => esc_html__( 'Top', TEXT_DOMAIN ),
                    'top-end'      => esc_html__( 'Top Right', TEXT_DOMAIN ),
                    'bottom-start' => esc_html__( 'Bottom Left', TEXT_DOMAIN ),
                    'bottom'       => esc_html__( 'Bottom', TEXT_DOMAIN ),
                    'bottom-end'   => esc_html__( 'Bottom Right', TEXT_DOMAIN ),
                    'left'         => esc_html__( 'Left', TEXT_DOMAIN ),
                    'right'        => esc_html__( 'Right', TEXT_DOMAIN ),
                ],
                'condition'   => [
                    'logo_tooltip' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'logo_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',
                'default' => [
                    ['image' => ['url' => RBT_ASSETS_URL . 'images/no-image.jpg' ]],
                    ['image' => ['url' => RBT_ASSETS_URL . 'images/no-image.jpg' ]],
                    ['image' => ['url' => RBT_ASSETS_URL . 'images/no-image.jpg' ]],
                    ['image' => ['url' => RBT_ASSETS_URL . 'images/no-image.jpg' ]],
                    ['image' => ['url' => RBT_ASSETS_URL . 'images/no-image.jpg' ]],
                    ['image' => ['url' => RBT_ASSETS_URL . 'images/no-image.jpg' ]],
                    ['image' => ['url' => RBT_ASSETS_URL . 'images/no-image.jpg' ]],
                    ['image' => ['url' => RBT_ASSETS_URL . 'images/no-image.jpg' ]],
                ]
            ]
        );

		$this->end_controls_section();
		
	}

	protected function register_navigation_controls() {

		$this->start_controls_section(
			'section_content_navigation',
			[
				'label' => __('Navigation', TEXT_DOMAIN),
			]
		);
		
		$this->add_control(
			'navigation',
			[
				'label'        => __( 'Navigation', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SELECT,
				'default'      => 'arrows',
				'options'      => [
					'both'            => esc_html__( 'Arrows and Dots', TEXT_DOMAIN ),
					'arrows-fraction' => esc_html__( 'Arrows and Fraction', TEXT_DOMAIN ),
					'arrows'          => esc_html__( 'Arrows', TEXT_DOMAIN ),
					'dots'            => esc_html__( 'Dots', TEXT_DOMAIN ),
					'progressbar'     => esc_html__( 'Progress', TEXT_DOMAIN ),
					'none'            => esc_html__( 'None', TEXT_DOMAIN ),
				],
				'prefix_class' => 'rbt-navigation-type-',
				'render_type'  => 'template',
			]
		);
		
		$this->add_control(
			'dynamic_bullets',
			[
				'label'     => __( 'Dynamic Bullets?', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'navigation' => ['dots', 'both'],
				],
			]
		);
		
		$this->add_control(
			'show_scrollbar',
			[
				'label' => __( 'Show Scrollbar?', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'both_position',
			[
				'label'     => __( 'Arrows and Dots Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'both',
				],
			
			]
		);
		
		$this->add_control(
			'arrows_fraction_position',
			[
				'label'     => __( 'Arrows and Fraction Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			
			]
		);
		
		$this->add_control(
			'arrows_position',
			[
				'label'     => __( 'Arrows Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'arrows',
				],
			
			]
		);
		
		$this->add_control(
			'dots_position',
			[
				'label'     => __( 'Dots Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'bottom-center',
				'options'   => rbt_pagination_position(),
				'condition' => [
					'navigation' => 'dots',
				],
			
			]
		);
		
		$this->add_control(
			'progress_position',
			[
				'label'     => __( 'Progress Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'bottom',
				'options'   => [
					'bottom' => esc_html__( 'Bottom', TEXT_DOMAIN ),
					'top'    => esc_html__( 'Top', TEXT_DOMAIN ),
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			
			]
		);
		
		$this->add_control(
			'nav_arrows_icon',
			[
				'label'     => esc_html__( 'Arrows Icon', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '5',
				'options'   => [
					'1'        => esc_html__( 'Style 1', TEXT_DOMAIN ),
					'2'        => esc_html__( 'Style 2', TEXT_DOMAIN ),
					'3'        => esc_html__( 'Style 3', TEXT_DOMAIN ),
					'4'        => esc_html__( 'Style 4', TEXT_DOMAIN ),
					'5'        => esc_html__( 'Style 5', TEXT_DOMAIN ),
					'6'        => esc_html__( 'Style 6', TEXT_DOMAIN ),
					'7'        => esc_html__( 'Style 7', TEXT_DOMAIN ),
					'8'        => esc_html__( 'Style 8', TEXT_DOMAIN ),
					'9'        => esc_html__( 'Style 9', TEXT_DOMAIN ),
					'10'       => esc_html__( 'Style 10', TEXT_DOMAIN ),
					'11'       => esc_html__( 'Style 11', TEXT_DOMAIN ),
					'12'       => esc_html__( 'Style 12', TEXT_DOMAIN ),
					'13'       => esc_html__( 'Style 13', TEXT_DOMAIN ),
					'14'       => esc_html__( 'Style 14', TEXT_DOMAIN ),
					'15'       => esc_html__( 'Style 15', TEXT_DOMAIN ),
					'16'       => esc_html__( 'Style 16', TEXT_DOMAIN ),
					'17'       => esc_html__( 'Style 17', TEXT_DOMAIN ),
					'18'       => esc_html__( 'Style 18', TEXT_DOMAIN ),
					'circle-1' => esc_html__( 'Style 19', TEXT_DOMAIN ),
					'circle-2' => esc_html__( 'Style 20', TEXT_DOMAIN ),
					'circle-3' => esc_html__( 'Style 21', TEXT_DOMAIN ),
					'circle-4' => esc_html__( 'Style 22', TEXT_DOMAIN ),
					'square-1' => esc_html__( 'Style 23', TEXT_DOMAIN ),
				],
				'condition' => [
					'navigation' => ['arrows-fraction', 'both', 'arrows'],
				],
			]
		);
		
		$this->add_control(
			'hide_arrow_on_mobile',
			[
				'label'     => __( 'Hide Arrow on Mobile', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => [
					'navigation' => ['arrows-fraction', 'arrows', 'both'],
				],
			]
		);

		$this->end_controls_section();
		
	}
	
	protected function register_carousel_settings_controls() {
		$this->start_controls_section(
			'section_carousel_settings',
			[
				'label' => __( 'Carousel Settings', TEXT_DOMAIN ),
			]
		);
		
		$this->add_control(
			'autoplay',
			[
				'label'   => __( 'Autoplay', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			
			]
		);
		
		$this->add_control(
			'autoplay_speed',
			[
				'label'     => esc_html__( 'Autoplay Speed', TEXT_DOMAIN ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 5000,
				'condition' => [
					'autoplay' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'pauseonhover',
			[
				'label' => esc_html__( 'Pause on Hover', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_responsive_control(
			'slides_to_scroll',
			[
				'type'           => Controls_Manager::SELECT,
				'label'          => esc_html__( 'Slides to Scroll', TEXT_DOMAIN ),
				'default'        => 1,
				'tablet_default' => 1,
				'mobile_default' => 1,
				'options'        => [
					1 => '1',
					2 => '2',
					3 => '3',
					4 => '4',
					5 => '5',
					6 => '6',
				],
			]
		);
		
		$this->add_control(
			'centered_slides',
			[
				'label'       => __( 'Center Slide', TEXT_DOMAIN ),
				'description' => __( 'Use even items from Layout > Columns settings for better preview.', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'grab_cursor',
			[
				'label' => __( 'Grab Cursor', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'free_mode',
			[
				'label' => __( 'Drag Free Mode', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'loop',
			[
				'label'   => __( 'Loop', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			
			]
		);
		
		$this->add_control(
			'speed',
			[
				'label'   => __( 'Animation Speed (ms)', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 500,
				],
				'range' => [
					'px' => [
						'min'  => 100,
						'max'  => 5000,
						'step' => 50,
					],
				],
			]
		);
		
		$this->add_control(
			'observer',
			[
				'label'       => __( 'Observer', TEXT_DOMAIN ),
				'description' => __( 'When you use carousel in any hidden place (in tabs, accordion etc) keep it yes.', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'show_hidden_item',
			[
				'label' => __( 'Show Hidden Item', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
				'prefix_class' => 'rbt-show-hidden-item--',
				'render_type' => 'template'
			]
		);

		$this->add_control(
			'hidden_item_opacity',
			[
				'label' => __( 'Hidden Item Opacity', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0.1,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-slide:not(.swiper-slide-visible)' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'show_hidden_item' => 'yes',
				],
			]
		);
		
		$this->end_controls_section();
	}

    // style //
	protected function register_style_slider_controls() {

		$this->start_controls_section(
			'section_style_slider',
			[
				'label' => esc_html__('Slider', TEXT_DOMAIN),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'slider_overlay_background_color',
			[
				'label'     => esc_html__('Overlay Color', TEXT_DOMAIN),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-panel-slide-item:before' => 'background-color: {{VALUE}}; transition: all .3s ease;',
				],
			]
		);

		$this->add_control(
			'slider_active_overlay_color',
			[
				'label'     => esc_html__('Active Overlay Color', TEXT_DOMAIN),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-panel-slide-item.swiper-slide-active:before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'slider_background_color',
			[
				'label'     => esc_html__('Overlay Hover Color', TEXT_DOMAIN),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-panel-slide-item .rbt-overlay-gradient' => 'background: linear-gradient(to bottom, rgba(255, 255, 255, 0) 40%, {{VALUE}} 100%);',
				],
			]
		);

		$this->add_control(
			'slider_opacity',
			[
				'label'   => esc_html__('Opacity', TEXT_DOMAIN),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0.4,
				],
				'range' => [
					'px' => [
						'min'  => 0,
						'max'  => 1,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-panel-slider .rbt-panel-slide-item .rbt-panel-slide-thumb img' => 'opacity: {{SIZE}};',
					'{{WRAPPER}} .rbt-panel-slider.rbt-skin-middle .swiper-slide:not(.swiper-slide-active):hover .rbt-panel-slide-thumb img' => 'opacity: {{SIZE}} !important;',

				],
			]
		);

		$this->add_responsive_control(
			'desc_padding',
			[
				'label'     => esc_html__('Description Padding', TEXT_DOMAIN),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rbt-panel-slider .rbt-panel-slide-desc' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_img_controls() {
		$this->start_controls_section(
			'section_style_img',
			[
				'label' => esc_html__('Image', TEXT_DOMAIN),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'size_img',
			[
				'label'   => esc_html__('Size', TEXT_DOMAIN),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px','%'],
				'range' => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
					],
					'%' => [
						'min'  => 0,
						'max'  => 100,
					]
				],
				'default' => [
					// 'size' => 0.4,
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-panel-slider figure img' => 'width: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->end_controls_section();
	}

	protected function register_navigation_style_controls($name) {
		$this->start_controls_section(
			'section_style_navigation',
			[
				'label'      => __('Navigation', TEXT_DOMAIN),
				'tab'        => Controls_Manager::TAB_STYLE,
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'navigation',
							'operator' => '!=',
							'value'    => 'none',
						],
						[
							'name'  => 'show_scrollbar',
							'value' => 'yes',
						],
					],
				],
			]
		);
		
		$this->add_control(
			'arrows_heading',
			[
				'label'     => __( 'A R R O W S', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->start_controls_tabs( 'tabs_navigation_arrows_style' );
		
		$this->start_controls_tab(
			'tabs_nav_arrows_normal',
			[
				'label'     => __( 'Normal', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'arrows_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev i, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next i' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'arrows_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'nav_arrows_border',
				'selector'  => '{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next',
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'border_radius',
			[
				'label'      => __( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_size',
			[
				'label'     => __( 'Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev i,
		{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next i' => 'font-size: {{SIZE || 24}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_space',
			[
				'label'     => __( 'Space Between Arrows', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev' => 'margin-right: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'margin-left: {{SIZE}}px;',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'arrows_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next',
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tabs_nav_arrows_hover',
			[
				'label'     => __( 'Hover', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'arrows_hover_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev:hover i, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next:hover i' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'arrows_hover_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev:hover, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next:hover' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'nav_arrows_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev:hover, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'nav_arrows_border_border!' => '',
					'navigation!'               => ['dots', 'progressbar', 'none'],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'arrows_hover_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev:hover, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next:hover',
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();
		
		$this->add_control(
			'hr_1',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'dots_heading',
			[
				'label'     => __( 'D O T S', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->start_controls_tabs( 'tabs_navigation_dots_style' );
		
		$this->start_controls_tab(
			'tabs_nav_dots_normal',
			[
				'label'     => __( 'Normal', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'dots_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->add_responsive_control(
			'dots_space_between',
			[
				'label'     => __( 'Space Between', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}}' => '--ep-swiper-dots-space-between: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'dots_size',
			[
				'label'     => __( 'Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 5,
						'max' => 20,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => ''
				],
			]
		);
		
		$this->add_control(
			'advanced_dots_size',
			[
				'label'     => __( 'Advanced Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'advanced_dots_width',
			[
				'label'     => __( 'Width(px)', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);
		
		$this->add_responsive_control(
			'advanced_dots_height',
			[
				'label'     => __( 'Height(px)', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'advanced_dots_radius',
			[
				'label'      => esc_html__('Border Radius', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'dots_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet',
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_nav_dots_active',
			[
				'label'     => __( 'Active', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->add_control(
			'active_dot_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->add_responsive_control(
			'active_dots_size',
			[
				'label'     => __( 'Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 5,
						'max' => 20,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}' => '--ep-swiper-dots-active-height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => ''
				],
			]
		);
		
		$this->add_responsive_control(
			'active_advanced_dots_width',
			[
				'label'     => __( 'Width(px)', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);
		
		$this->add_responsive_control(
			'active_advanced_dots_height',
			[
				'label'     => __( 'Height(px)', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}' => '--ep-swiper-dots-active-height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'active_advanced_dots_radius',
			[
				'label'      => esc_html__('Border Radius', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'active_advanced_dots_align',
			[
				'label'   => __( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => __( 'Top', TEXT_DOMAIN ),
						'icon'  => 'eicon-v-align-top',
					],
					'center' => [
						'title' => __( 'Center', TEXT_DOMAIN ),
						'icon'  => 'eicon-v-align-middle',
					],
					'flex-end' => [
						'title' => __( 'Bottom', TEXT_DOMAIN ),
						'icon'  => 'eicon-v-align-bottom',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-swiper-dots-align: {{VALUE}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'dots_active_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active',
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->add_control(
			'hr_2',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'fraction_heading',
			[
				'label'     => __( 'F R A C T I O N', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'hr_12',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'fraction_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-fraction' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'active_fraction_color',
			[
				'label'     => __( 'Active Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-current' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'fraction_typography',
				'label'     => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
				'selector'  => '{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-fraction',
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'hr_3',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'progresbar_heading',
			[
				'label'     => __( 'P R O G R E S B A R', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'hr_13',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'progresbar_color',
			[
				'label'     => __( 'Bar Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-progressbar' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'progres_color',
			[
				'label'     => __( 'Progress Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'separator' => 'after',
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-progressbar .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'hr_4',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'scrollbar_heading',
			[
				'label'     => __( 'S C R O L L B A R', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'hr_14',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'scrollbar_color',
			[
				'label'     => __( 'Bar Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-scrollbar' => 'background: {{VALUE}}',
				],
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'scrollbar_drag_color',
			[
				'label'     => __( 'Drag Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-scrollbar .swiper-scrollbar-drag' => 'background: {{VALUE}}',
				],
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'scrollbar_height',
			[
				'label'     => __( 'Height', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-container-horizontal > .swiper-scrollbar' => 'height: {{SIZE}}px;',
				],
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'hr_05',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'navi_offset_heading',
			[
				'label' => __( 'O F F S E T', TEXT_DOMAIN ),
				'type'  => Controls_Manager::HEADING,
			]
		);
		
		$this->add_control(
			'hr_6',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_responsive_control(
			'arrows_ncx_position',
			[
				'label'          => __( 'Arrows Horizontal Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'     => 'arrows_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-arrows-ncx: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_ncy_position',
			[
				'label'          => __( 'Arrows Vertical Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-arrows-ncy: {{SIZE}}px;'
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'     => 'arrows_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_acx_position',
			[
				'label'      => __( 'Arrows Horizontal Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => -60,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'  => 'arrows_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'dots_nnx_position',
			[
				'label'          => __( 'Dots Horizontal Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'dots',
						],
						[
							'name'     => 'dots_position',
							'operator' => '!=',
							'value'    => '',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-dots-nnx: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'dots_nny_position',
			[
				'label'          => __( 'Dots Vertical Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 30,
				],
				'tablet_default' => [
					'size' => 30,
				],
				'mobile_default' => [
					'size' => 30,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'dots',
						],
						[
							'name'     => 'dots_position',
							'operator' => '!=',
							'value'    => '',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-dots-nny: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'both_ncx_position',
			[
				'label'          => __( 'Arrows & Dots Horizontal Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'     => 'both_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-both-ncx: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'both_ncy_position',
			[
				'label'          => __( 'Arrows & Dots Vertical Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'     => 'both_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-both-ncy: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'both_cx_position',
			[
				'label'      => __( 'Arrows Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => -60,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'  => 'both_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'both_cy_position',
			[
				'label'      => __( 'Dots Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => 30,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-dots-container' => 'transform: translateY({{SIZE}}px);',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'  => 'both_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_fraction_ncx_position',
			[
				'label'          => __( 'Arrows & Fraction Horizontal Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'     => 'arrows_fraction_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-arrows-fraction-ncx: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_fraction_ncy_position',
			[
				'label'          => __( 'Arrows & Fraction Vertical Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'     => 'arrows_fraction_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-arrows-fraction-ncy: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_fraction_cx_position',
			[
				'label'      => __( 'Arrows Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => -60,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'  => 'arrows_fraction_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_fraction_cy_position',
			[
				'label'      => __( 'Fraction Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => 30,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-fraction' => 'transform: translateY({{SIZE}}px);',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'  => 'arrows_fraction_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'progress_y_position',
			[
				'label'     => __( 'Progress Offset', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => [
					'size' => 15,
				],
				'range'     => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-progressbar' => 'transform: translateY({{SIZE}}px);',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_responsive_control(
			'scrollbar_vertical_offset',
			[
				'label'     => __( 'Scrollbar Offset', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-container-horizontal > .swiper-scrollbar' => 'bottom: {{SIZE}}px;',
				],
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->update_responsive_control(
			'arrows_acx_position',
			[
				'default'        => [
					'size' => 20,
				],
				'tablet_default' => [
					'size' => 20,
				],
				'mobile_default' => [
					'size' => 20,
				],
			]
		);

		$this->end_controls_section();
		
	}
	
	protected function render_header(){
		$id              = 'rbt-panel-slider-' . $this->get_id();
		$settings        = $this->get_settings_for_display();

		$elementor_vp_lg = get_option('elementor_viewport_lg');
		$elementor_vp_md = get_option('elementor_viewport_md');
		$viewport_lg = !empty($elementor_vp_lg) ? $elementor_vp_lg - 1 : 1023;
		$viewport_md = !empty($elementor_vp_md) ? $elementor_vp_md - 1 : 767;

		if ('arrows' == $settings['navigation']) {
			$this->add_render_attribute('panel-slider', 'class', 'rbt-arrows-align-' . $settings['arrows_position']);
		} elseif ('dots' == $settings['navigation']) {
			$this->add_render_attribute('panel-slider', 'class', 'rbt-dots-align-' . $settings['dots_position']);
		} elseif ('both' == $settings['navigation']) {
			$this->add_render_attribute('panel-slider', 'class', 'rbt-arrows-dots-align-' . $settings['both_position']);
		} elseif ('arrows-fraction' == $settings['navigation']) {
			$this->add_render_attribute('panel-slider', 'class', 'rbt-arrows-dots-align-' . $settings['arrows_fraction_position']);
		}

		if ('arrows-fraction' == $settings['navigation']) {
			$pagination_type = 'fraction';
		} elseif ('both' == $settings['navigation'] or 'dots' == $settings['navigation']) {
			$pagination_type = 'bullets';
		} elseif ('progressbar' == $settings['navigation']) {
			$pagination_type = 'progressbar';
		} else {
			$pagination_type = '';
		}

		$columns         = $settings['columns'];
		$columns_tablet  = $settings['columns_tablet'];
		$columns_mobile  = $settings['columns_mobile'];

		$this->add_render_attribute(
			[
				'panel-slider' => [

					'data-settings' => [
						wp_json_encode(array_filter([
							"autoplay"        => ("yes" == $settings["autoplay"]) ? ["delay" => $settings["autoplay_speed"]] : false,
							"loop"            => ($settings["loop"] == "yes") ? true : false,
							"speed"           => $settings["speed"]["size"],
							"pauseOnHover"    => ("yes" == $settings["pauseonhover"]) ? true : false,
							"slidesPerView"  => (int) $columns_mobile,
							"slidesPerGroup"  => isset($settings["slides_to_scroll_mobile"]) ? (int)$settings["slides_to_scroll_mobile"] : 1,
							"spaceBetween"    => $settings['column_space']['size'] ?: 0,
							"centeredSlides"  => ($settings["centered_slides"] === "yes") ? true : false,
							"grabCursor"      => ($settings["grab_cursor"] === "yes") ? true : false,
							"freeMode"        => ($settings["free_mode"] === "yes") ? true : false,
							"observer"        => ($settings["observer"]) ? true : false,
							"observeParents"  => ($settings["observer"]) ? true : false,
							"breakpoints"     => [
								(int)$viewport_md => [
									"slidesPerView"  => (int) $columns_tablet,
									"spaceBetween"   => $settings['column_space']['size'] ?: 0,
									"slidesPerGroup" => isset($settings["slides_to_scroll_tablet"]) ? (int)$settings["slides_to_scroll_tablet"] : 1,
								],
								(int)$viewport_lg => [
									"slidesPerView"  => (int) $columns,
									"spaceBetween"   => $settings['column_space']['size'] ?: 0,
									"slidesPerGroup" => isset($settings["slides_to_scroll"]) ? (int)$settings["slides_to_scroll"] : 1,
								]
							],
							"navigation"      => [
								"nextEl" => "#" . $id . " .rbt-navigation-next",
								"prevEl" => "#" . $id . " .rbt-navigation-prev",
							],
							"pagination"      => [
								"el"             => "#" . $id . " .swiper-pagination",
								"type"           => $pagination_type,
								"clickable"      => "true",
								'dynamicBullets' => ("yes" == $settings["dynamic_bullets"]) ? true : false,
							],
							"scrollbar"       => [
								"el"   => "#" . $id . " .swiper-scrollbar",
								"hide" => "true",
							],
						]))
					],


					'class' => [
						'rbt-panel-slider',
					],


					'id' => $id
				]
			]
		);

		$this->add_render_attribute(
			[
				'panel-slider' => [
					'data-widget-settings' => [
						wp_json_encode([
							'id' => '#' . $id,
						])
					]
				]
			]
		);

        ?>
		<div <?php echo $this->get_render_attribute_string('panel-slider'); ?>>
			<div class="swiper-container">
			    <div class="swiper-wrapper">
			    <?php
	}

	public function render_navigation() {
		$settings = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? ' rbt-visible@m' : '';
		
		if ( 'arrows' == $settings['navigation'] ) : ?>
			<div class="rbt-position-z-index rbt-position-<?php echo esc_attr( $settings['arrows_position'] . $hide_arrow_on_mobile ); ?>">
				<div class="rbt-arrows-container rbt-slidenav-container">
					<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
						<i class="ep-arrow-left-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
					</a>
					<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
						<i class="ep-arrow-right-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
					</a>
				</div>
			</div>
		<?php endif;
	}

	function render_pagination() {
		$settings = $this->get_settings_for_display();
		
		if ( 'dots' == $settings['navigation'] or 'arrows-fraction' == $settings['navigation'] ) : ?>
			<div class="rbt-position-z-index rbt-position-<?php
				echo esc_attr( $settings['dots_position'] ); ?>">
				<div class="rbt-dots-container">
					<div class="swiper-pagination"></div>
				</div>
			</div>
		
		<?php
		elseif ( 'progressbar' == $settings['navigation'] ) : ?>
			<div class="swiper-pagination rbt-position-z-index rbt-position-<?php
				echo esc_attr( $settings['progress_position'] ); ?>"></div>
		<?php
		endif;
	}

	public function render_both_navigation() {
		$settings = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? 'rbt-visible@m' : '';
		
		?>
		<div class="rbt-position-z-index rbt-position-<?php echo esc_attr($settings['both_position']); ?>">
			<div class="rbt-arrows-dots-container rbt-slidenav-container ">
				
				<div class="rbt-flex rbt-flex-middle">
					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
							<i class="ep-arrow-left-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
						</a>
					</div>

					<?php if ('center' !== $settings['both_position']) : ?>
						<div class="swiper-pagination"></div>
					<?php endif; ?>
					
					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
							<i class="ep-arrow-right-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
						</a>
					</div>
					
				</div>
			</div>
		</div>		
		<?php
	}

	function render_arrows_fraction() {
		$settings = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? 'rbt-visible@m' : '';
		
		?>
		<div class="rbt-position-z-index rbt-position-<?php
			echo esc_attr( $settings['arrows_fraction_position'] ); ?>">
			<div class="rbt-arrows-fraction-container rbt-slidenav-container ">
				
				<div class="rbt-flex rbt-flex-middle">
					<div class="<?php
						echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
							<i class="ep-icon-arrow-left-<?php
								echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
						</a>
					</div>
					
					<?php
						if ( 'center' !== $settings['arrows_fraction_position'] ) : ?>
							<div class="swiper-pagination"></div>
						<?php
						endif; ?>
					
					<div class="<?php
						echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
							<i class="ep-icon-arrow-right-<?php
								echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
						</a>
					</div>
				
				</div>
			</div>
		</div>
		<?php
	}

	function render_footer() {
		$settings = $this->get_settings_for_display();
		
		?>
		</div>
		<?php
		if ( 'yes' === $settings['show_scrollbar'] ) : ?>
			<div class="swiper-scrollbar"></div>
		<?php
		endif; ?>
		</div>
		
		<?php
		if ( 'both' == $settings['navigation'] ) : ?>
			<?php $this->render_both_navigation(); ?>
			<?php
			if ( 'center' === $settings['both_position'] ) : ?>
				<div class="rbt-position-z-index rbt-position-bottom">
					<div class="rbt-dots-container">
						<div class="swiper-pagination"></div>
					</div>
				</div>
			<?php
			endif; ?>
		<?php
		elseif ( 'arrows-fraction' == $settings['navigation'] ) : ?>
			<?php $this->render_arrows_fraction(); ?>
			<?php
			if ( 'center' === $settings['arrows_fraction_position'] ) : ?>
				<div class="rbt-dots-container">
					<div class="swiper-pagination"></div>
				</div>
			<?php
			endif; ?>
		<?php
		else : ?>
			<?php $this->render_pagination(); ?>
			<?php $this->render_navigation(); ?>
		<?php
		endif; ?>
		
		</div>
		<?php
	}

    private function loop_items(){
		$settings = $this->get_settings_for_display();
		$counter   = 1;

		if ( empty($settings['logo_list'] ) ) {
            return;
        }


		foreach ($settings['logo_list'] as $item) :

			$image = wp_get_attachment_image_url( $item['image']['id'], $settings['thumbnail_size'] );
            $repeater_key = 'carousel_item';
            $tag = 'li';
            $image_alt = esc_html($item['name']) . ' : ' . esc_html($item['description']); 
            $this->add_render_attribute( $repeater_key, 'class', 'rbt-logo-carousel-item' );

            if ( $item['link']['url'] ) {
                $tag = 'a';
                $this->add_render_attribute( $repeater_key, 'class', 'rbt-logo-carousel-link' );
                $this->add_render_attribute( $repeater_key, 'target', '_blank' );
                $this->add_render_attribute( $repeater_key, 'rel', 'noopener' );
                $this->add_render_attribute( $repeater_key, 'href', esc_url( $item['link']['url'] ) );
                $this->add_render_attribute( $repeater_key, 'title', $item['name'] );
            }

            if ($item['name'] and $item['description'] and $item['logo_tooltip']) {
                // Tooltip settings
            	$tooltip_content = '<div><strong>' . $item['name'] . '</strong></div>' . $item['description']; 
            	$this->add_render_attribute( $repeater_key, 'data-tippy-content', $tooltip_content, true);
                
                $this->add_render_attribute( $repeater_key, 'class', 'rbt-tippy-tooltip' );
                $this->add_render_attribute( $repeater_key, 'data-tippy', '', true );

                if ($item['logo_tooltip_placement']) {
                    $this->add_render_attribute( $repeater_key, 'data-tippy-placement', $item['logo_tooltip_placement'], true );
                }

                if ($settings['logo_tooltip_animation']) {
                    $this->add_render_attribute( $repeater_key, 'data-tippy-animation', $settings['logo_tooltip_animation'], true );
                }

                if ($settings['logo_tooltip_x_offset']['size'] or $settings['logo_tooltip_y_offset']['size']) {
                    $this->add_render_attribute( $repeater_key, 'data-tippy-offset', $settings['logo_tooltip_x_offset']['size'] .','. $settings['logo_tooltip_y_offset']['size'], true );
                }

                if ('yes' == $settings['logo_tooltip_arrow']) {
                    $this->add_render_attribute( $repeater_key, 'data-tippy-arrow', 'true', true );
                }

                if ('yes' == $settings['logo_tooltip_trigger']) {
                    $this->add_render_attribute( $repeater_key, 'data-tippy-trigger', 'click', true );
                }

            }

			$this->add_render_attribute('panel-slide-item', 'class', ['rbt-panel-slide-item', 'swiper-slide', 'rbt-transition-toggle'], true);
			$this->add_render_attribute('panel-slide-item-title', 'class', ['rbt-panel-slide-title'], true);

			?>
			<div <?php echo $this->get_render_attribute_string('panel-slide-item'); ?>>

				<div class="rbt-panel-slide-desc rbt-position-z-index">


					<<?php echo $tag; ?> <?php $this->print_render_attribute_string( $repeater_key ); ?>>
						<figure class="rbt-logo-carousel-figure">
						<?php if ( $image ) :

								echo wp_get_attachment_image(
									$item['image']['id'],
									$settings['thumbnail_size'],
									false,
									[
										'class' => 'rbt-logo-carousel-img elementor-animation-',
										'alt'=> esc_attr( $image_alt ),
									]
								);
							
							else :
								printf( '<img class="rbt-logo-carousel-img elementor-animation-%s" src="%s" alt="%s">',
									esc_attr( $settings['hover_animation'] ),
									RBT_ASSETS_URL . 'images/no-image.jpg',
									esc_attr( $image_alt )
									);
							endif; ?>

						</figure>
					</<?php echo $tag; ?>>


			    </div>

			</div>
			<?php

		$counter++;
		endforeach;
		
	}

	public function render(){
		$this->render_header();
        $this->loop_items();
	    $this->render_footer();
	}

}