<?php

namespace RoboTheme\inc\elementor\Modules\Accordion\Widgets;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;
use Elementor\Plugin;
use RoboTheme\RoboTheme_Loader;

if ( !defined('ABSPATH') ) exit; // Exit if accessed directly

class RBT_Accordion extends Widget_Base {

    public function get_name() {
        return 'rbt-accordion';
    }

    public function get_title() {
        return esc_html__('Accordion', TEXT_DOMAIN );
    }

    public function get_icon() {
        return 'eicon-accordion';
    }

    public function get_categories() {
        return [RBT_CAT];
    }

    public function get_keywords() {
        return ['accordion', 'tabs', 'toggle'];
    }

    public function get_style_depends() {
        return ['rbt-accordion'];
    }

    public function get_script_depends() {
        return ['rbt-accordion'];
    }

    protected function register_controls() {
        $this->register_controls_content_accordion();
        $this->register_controls_content_additional();
        $this->register_controls_style_Item();
        $this->register_controls_style_Title();
        $this->register_controls_style_Icon();
        $this->register_controls_style_content();  
    }

    protected function register_controls_content_accordion() {

        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'Accordion', TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label'   => __( 'Accordion Items', TEXT_DOMAIN ),
                'type'    => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'tab_title'   => __( 'Accordion #1', TEXT_DOMAIN ),
                        'tab_content' => __( 'I am item content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', TEXT_DOMAIN ),
                    ],
                    [
                        'tab_title'   => __( 'Accordion #2', TEXT_DOMAIN ),
                        'tab_content' => __( 'I am item content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', TEXT_DOMAIN ),
                    ],
                    [
                        'tab_title'   => __( 'Accordion #3', TEXT_DOMAIN ),
                        'tab_content' => __( 'I am item content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', TEXT_DOMAIN ),
                    ],
                ],
                'fields' => [
                    [
                        'name'        => 'tab_title',
                        'label'       => __( 'Title & Content', TEXT_DOMAIN ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => __( 'Title' , TEXT_DOMAIN ),
                        'label_block' => true,
                    ],
                    [
                        'name'       => 'tab_content',
                        'label'      => __( 'Content', TEXT_DOMAIN ),
                        'type'       => Controls_Manager::WYSIWYG,
                        'dynamic'    => [ 'active' => true ],
                        'default'    => __( 'Content', TEXT_DOMAIN ),
                        'show_label' => false,
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );

        $this->add_control(
            'view',
            [
                'label'   => __( 'View', TEXT_DOMAIN ),
                'type'    => Controls_Manager::HIDDEN,
                'default' => 'traditional',
            ]
        );

        $this->add_control(
            'title_html_tag',
            [
                'label'   => __( 'Title HTML Tag', TEXT_DOMAIN ),
                'type'    => Controls_Manager::SELECT,
                'options' => rbt_Title_Tags(),
                'default' => 'div',
            ]
        );

        $this->add_control(
            'accordion_icon',
            [
                'label'       => __( 'Icon', TEXT_DOMAIN ),
                'type'        => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-plus',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_control(
            'accordion_active_icon',
            [
                'label'       => __( 'Active Icon', TEXT_DOMAIN ),
                'type'        => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon_active',
                'default' => [
                    'value' => 'fas fa-minus',
                    'library' => 'fa-solid',
                ],
                'condition'   => [
                    'accordion_icon[value]!' => '',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_controls_content_additional() {

        $this->start_controls_section(
            'section_content_additional',
            [
                'label' => __( 'Additional', TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'multiple',
            [
                'label' => __( 'Multiple Open', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'active_item',
            [
                'label' => __( 'Active Item No', TEXT_DOMAIN ),
                'type'  => Controls_Manager::NUMBER,
                'min'   => 1,
                'max'   => 20,
            ]
        );

        $this->end_controls_section();
    }
    
    protected function register_controls_style_Item() {

        $this->start_controls_section(
            'section_style_item',
            [
                'label' => __( 'Item', TEXT_DOMAIN ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'   => __( 'Alignment', TEXT_DOMAIN ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon'  => 'fas fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon'  => 'fas fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon'  => 'fas fa-align-right',
                    ],
                ],
            ]
        );

        $this->add_control(
            'item_spacing',
            [
                'label' => __( 'Item Spacing', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-item + .rbt-accordion-item' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function register_controls_style_Title() {

        $this->start_controls_section(
            'section_toggle_style_title',
            [
                'label' => __( 'Title', TEXT_DOMAIN ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'tabs_title_style' );

        $this->start_controls_tab(
            'tab_title_normal',
            [
                'label' => __( 'Normal', TEXT_DOMAIN ),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'title_background',
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}} .rbt-accordion .rbt-accordion-title',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-title' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'title_shadow',
                'selector' => '{{WRAPPER}} .rbt-accordion .rbt-accordion-item .rbt-accordion-title',
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => __( 'Padding', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'title_border',
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .rbt-accordion .rbt-accordion-item .rbt-accordion-title',
            ]
        );

        $this->add_control(
            'title_radius',
            [
                'label'      => __( 'Border Radius', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-item .rbt-accordion-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .rbt-accordion .rbt-accordion-title',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_title_active',
            [
                'label' => __( 'Active', TEXT_DOMAIN ),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'active_title_background',
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}} .rbt-accordion .rbt-accordion-item .rbt-accordion-title.rbt-open',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'active_title_color',
            [
                'label'     => __( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-item .rbt-accordion-title.rbt-open' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'active_title_shadow',
                'selector' => '{{WRAPPER}} .rbt-accordion .rbt-accordion-item .rbt-accordion-title.rbt-open',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'active_title_border',
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .rbt-accordion .rbt-accordion-item .rbt-accordion-title.rbt-open',
            ]
        );

        $this->add_control(
            'active_title_radius',
            [
                'label'      => __( 'Border Radius', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-item .rbt-accordion-title.rbt-open' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function register_controls_style_Icon() {

        $this->start_controls_section(
            'section_toggle_style_icon',
            [
                'label'     => __( 'Icon', TEXT_DOMAIN ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'accordion_icon[value]!' => '',
                ],
            ]
        );

        $this->start_controls_tabs( 'tabs_icon_style' );

        $this->start_controls_tab(
            'tab_icon_normal',
            [
                'label' => __( 'Normal', TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'icon_align',
            [
                'label'   => __( 'Alignment', TEXT_DOMAIN ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => is_rtl() ? __( 'End', TEXT_DOMAIN ) : __( 'Start', TEXT_DOMAIN ),
                        'icon'  => is_rtl() ? 'eicon-h-align-right' : 'eicon-h-align-left',
                    ],
                    'right' => [
                        'title' => is_rtl() ? __( 'Start', TEXT_DOMAIN ) : __( 'End', TEXT_DOMAIN ),
                        'icon'  => is_rtl() ? 'eicon-h-align-left' : 'eicon-h-align-right',
                    ],
                ],
                'default'     => is_rtl() ? 'left' : 'right',
                'toggle'      => false,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'icon_align_reverse',
            [
                'label'   => __( 'Reverse', TEXT_DOMAIN ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'no',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-title .rbt-accordion-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-title .rbt-accordion-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_space',
            [
                'label' => __( 'Spacing', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-icon.rbt-flex-align-left'  => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-icon.rbt-flex-align-right' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_icon_active',
            [
                'label' => __( 'Active', TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'icon_active_color',
            [
                'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-title.rbt-open .rbt-accordion-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-title.rbt-open .rbt-accordion-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Icon Size', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min'  => 10,
                        'max'  => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-title .rbt-accordion-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tabs();

        $this->end_controls_section();

    }
 
    protected function register_controls_style_content() {

        $this->start_controls_section(
            'section_toggle_style_content',
            [
                'label'     => __( 'Content', TEXT_DOMAIN ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'content_background_color',
                'types'     => [ 'classic', 'gradient' ],
                'selector'  => '{{WRAPPER}} .rbt-accordion .rbt-accordion-content',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label'     => __( 'Color', TEXT_DOMAIN ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-content' => 'color: {{VALUE}};',
                    'separator' => 'before',
                ],
            ]
        );

        $this->add_control(
            'content_radius',
            [
                'label'      => __( 'Border Radius', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => __( 'Padding', TEXT_DOMAIN ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_spacing',
            [
                'label' => __( 'Spacing', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-accordion .rbt-accordion-content' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typography',
                'selector' => '{{WRAPPER}} .rbt-accordion .rbt-accordion-content',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $id       = 'rbt-accordion-' . $this->get_id();

        $this->add_render_attribute(['accordion' => ['id' => $id, 'class' => 'rbt-accordion',]]);

        $migrated = isset( $settings['__fa4_migrated']['accordion_icon'] );
        $is_new = empty( $settings['icon'] ) && Icons_Manager::is_migration_allowed();

        $active_migrated  = isset( $settings['__fa4_migrated']['accordion_active_icon'] );
        $active_is_new    = empty( $settings['icon_active'] ) && Icons_Manager::is_migration_allowed();

        if (Plugin::$instance->editor->is_edit_mode() ) {
            ?>
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                    $(".rbt-accordion-title").on("click", function() {
                        if ($(this).hasClass("rbt-open")) {
                            $(this).removeClass("rbt-open");
                            $(this).siblings(".rbt-accordion-content").slideUp(200);
                        } else {
                            if ($(this).hasClass("multiple")) {}
                            else {
                                $(".rbt-accordion-title").removeClass("rbt-open");
                                $(".rbt-accordion-content").slideUp(200);
                            }
                            $(this).addClass("rbt-open");
                            $(this).siblings(".rbt-accordion-content").slideDown(200);
                        }
                    });
                });
            </script>
            <?php
        }

        ?>
        <div class="rbt-accordion-container">
            <div <?php echo $this->get_render_attribute_string( 'accordion' ); ?>>

                <?php foreach ( $settings['tabs'] as $index => $item ) :
                    $acc_count = $index + 1;

                    $tab_title_setting_key = $this->get_repeater_setting_key( 'tab_title', 'tabs', $index );

                    $tab_content_setting_key = $this->get_repeater_setting_key( 'tab_content', 'tabs', $index );
                    
                    $this->add_render_attribute( $tab_title_setting_key, [
                        'class' => [ 
                            'rbt-accordion-title rbt-flex rbt-flex-' . esc_attr($settings['align']) 
                        ],
                    ]);

                    $this->add_render_attribute( $tab_title_setting_key, 'class', ( 'right' == $settings['icon_align'] ) ? 'rbt-flex-between' : '' );
                    $this->add_render_attribute( $tab_title_setting_key, 'class', ( 'yes' == $settings['icon_align_reverse'] ) ? 'rbt-flex-row-reverse' : '' );
                    $this->add_render_attribute( $tab_title_setting_key, 'class', ( $acc_count === $settings['active_item']) ? 'rbt-open' : '' );

                    if (true == $settings['multiple']){
                        $this->add_render_attribute( $tab_title_setting_key, ['class' => [ 'multiple' ],]);
                    }

                    $this->add_render_attribute( $tab_content_setting_key, [
                        'class' => [ 'rbt-accordion-content rbt-text-' . esc_attr($settings['align'])  ],
                    ]);

                    $this->add_inline_editing_attributes( $tab_content_setting_key, 'advanced' );
                    ?>

                    <div class="rbt-accordion-item<?php echo ($acc_count === $settings['active_item']) ? ' rbt-open' : ''; ?>">

                        <<?php echo $settings['title_html_tag']; ?> <?php echo $this->get_render_attribute_string( $tab_title_setting_key ); ?>>

                            <?php if ( $settings['accordion_icon']['value'] ) : ?>

                                <span class="rbt-accordion-icon rbt-flex-align-<?php echo esc_attr( $settings['icon_align'] ); ?>" aria-hidden="true">

                                    <?php if ( $is_new || $migrated ) : ?>
                                        <span class="rbt-accordion-icon-closed">
                                            <?php Icons_Manager::render_icon( $settings['accordion_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] ); ?>
                                        </span>
                                    <?php else : ?>
                                        <i class="rbt-accordion-icon-closed <?php echo esc_attr( $settings['icon'] ); ?>" aria-hidden="true"></i>
                                    <?php endif; ?>

                                    <?php if ( $active_is_new || $active_migrated ) : ?>
                                        <span class="rbt-accordion-icon-opened">
                                            <?php Icons_Manager::render_icon( $settings['accordion_active_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] ); ?>
                                        </span>
                                    <?php else : ?>
                                        <i class="rbt-accordion-icon-opened <?php echo esc_attr( $settings['icon_active'] ); ?>" aria-hidden="true"></i>
                                    <?php endif; ?>

                                </span>

                            <?php endif; ?>

                            <?php echo esc_html($item['tab_title']); ?>

                        </<?php echo esc_html($settings['title_html_tag']); ?>>

                        <div <?php echo $this->get_render_attribute_string( $tab_content_setting_key ); ?>>
                            <?php echo $this->parse_text_editor( $item['tab_content'] ); ?>
                        </div>

                    </div>

                <?php endforeach; ?>

            </div>
        </div>
        <?php
    }
    
}