<?php

namespace RoboTheme;

class Autoload {

    public function __construct() {
        spl_autoload_register([$this, 'autoload']);
    }

    public function autoload($class){

        if (0 !== strpos($class, __NAMESPACE__)) {
            return;
        }
    
        $class_to_load = $class;

        if (!class_exists($class_to_load)) {
    
            $filename = strtolower(
                preg_replace(
                    ['/^' . __NAMESPACE__ . '\\\/', '/([a-z])([A-Z])/', '/_/', '/\\\/'],
                    ['', '$1-$2', '-', DIRECTORY_SEPARATOR],
                    $class_to_load
                )
            );
    
            $filename = RBT_PATH . $filename . '.php';

            if (is_readable($filename)) {
                include($filename);
            }
        }
    
    }

}

new Autoload;