<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}
?>

<div id="comments" class="comments-area">

    <?php
    if ( have_comments() ) : ?>

        <h3 class="comments-title">
            <?php echo '<div class="flex align-items-center comments-number"> <i class="far fa-comments"></i> '; comments_number( __( 'No Responses', TEXT_DOMAIN ), __( '1 Response', TEXT_DOMAIN ), __( '% Responses', TEXT_DOMAIN ) ); echo '</div>'; ?>
        </h3>
        <ul class="comment-list">
            <?php
            wp_list_comments( array(
                'avatar_size' => 40,
                'short_ping'  => true,
                'reply_text'  => __( 'Reply', TEXT_DOMAIN ),
            ) );
            ?>
        </ul>
        <?php
        the_comments_pagination( array(
            'prev_text' => '<span class="comment-reader-text">' . __( 'Previous', TEXT_DOMAIN ) . '</span>',
            'next_text' => '<span class="comment-reader-text">' . __( 'Next', TEXT_DOMAIN ) . '</span>',
        ) );
    endif;

    
    if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
        <p class="no-comments"><?php _e( 'Comments are closed.', TEXT_DOMAIN ); ?></p>
    <?php
    endif;
    $commenter = wp_get_current_commenter();



    
    if ( ! isset( $args['format'] ) )
        $args['format'] = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : 'xhtml';
    $req = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );
    $html_req = ( $req ? " required='required'" : '' );
    $html5    = 'html5' === $args['format'];

    // render body //
    $comments_args = array(
        'comment_field' => 
        '<p class="comment-form-comment">
            <textarea class="form-control" id="comment" name="comment" aria-required="true" placeholder="' . __( "Write your own comment ...", "servin" ) . '" rows="8" cols="37" wrap="hard"></textarea>
        </p>',
        'cancel_reply_before'  => '',
        'cancel_reply_after'   => '',
        'cancel_reply_link'    => __( 'Cancel reply' ),
        'comment_notes_before' => '<p class="comment-notes"><span id="email-notes">' . __( 'Your email address will not be published.', TEXT_DOMAIN ) . '</span></p>',
        'fields' => apply_filters( 'comment_form_default_fields', array(

            'author' =>
                '<p class="comment-form-author">' .

                '<input id="author" name="author" placeholder="'. __( 'Name', TEXT_DOMAIN ) . ( $req ? '*' : '' )  .'" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
                '" size="30"' . $aria_req . ' /></p>',

            'email' =>
                '<p class="comment-form-email">' .

                '<input id="email" name="email" placeholder="'. __( 'Email', TEXT_DOMAIN ) . ( $req ? '*' : '' ) .  '" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
                '" size="30"' . $aria_req . ' /></p>',

            'url' => '',

            'cookies' => ''

        ) //fields array
        )
    );

    comment_form($comments_args);
    ?>
</div>