<?php

// Register Project Post Type //
function portfolio_post_type() {

    $labels = array(
        'name'                  => _x( 'Projects', 'Post type general name', TEXT_DOMAIN ),
        'singular_name'         => _x( 'Project', 'Post type singular name', TEXT_DOMAIN ),
        'menu_name'             => _x( 'Projects', 'Admin Menu text', TEXT_DOMAIN ),
        'name_admin_bar'        => _x( 'Project', 'Add New on Toolbar', TEXT_DOMAIN ),
        'add_new'               => __( 'Add New', TEXT_DOMAIN ),
        'add_new_item'          => __( 'Add New Project', TEXT_DOMAIN ),
        'new_item'              => __( 'New Project', TEXT_DOMAIN ),
        'edit_item'             => __( 'Edit Project', TEXT_DOMAIN ),
        'view_item'             => __( 'View Project', TEXT_DOMAIN ),
        'all_items'             => __( 'All Projects', TEXT_DOMAIN ),
        'search_items'          => __( 'Search Projects', TEXT_DOMAIN ),
        'parent_item_colon'     => __( 'Parent Projects:', TEXT_DOMAIN ),
        'not_found'             => __( 'No Projects found.', TEXT_DOMAIN ),
        'not_found_in_trash'    => __( 'No Projects found in Trash.', TEXT_DOMAIN ),
        'featured_image'        => _x( 'Project Cover Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', TEXT_DOMAIN ),
        'set_featured_image'    => _x( 'Set cover image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', TEXT_DOMAIN ),
        'remove_featured_image' => _x( 'Remove cover image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', TEXT_DOMAIN ),
        'use_featured_image'    => _x( 'Use as cover image', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', TEXT_DOMAIN ),
        'archives'              => _x( 'Project archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', TEXT_DOMAIN ),
        'insert_into_item'      => _x( 'Insert into Project', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', TEXT_DOMAIN ),
        'uploaded_to_this_item' => _x( 'Uploaded to this Project', 'Overrides the “Uploaded to this post”/”Uploaded to this page” phrase (used when viewing media attached to a post). Added in 4.4', TEXT_DOMAIN ),
        'filter_items_list'     => _x( 'Filter Projects list', 'Screen reader text for the filter links heading on the post type listing screen. Default “Filter posts list”/”Filter pages list”. Added in 4.4', TEXT_DOMAIN ),
        'items_list_navigation' => _x( 'Projects list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default “Posts list navigation”/”Pages list navigation”. Added in 4.4', TEXT_DOMAIN ),
        'items_list'            => _x( 'Projects list', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', TEXT_DOMAIN ),
    );
    $args = array(
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats', ),
        'taxonomies'            => array( 'portfolio_cat', 'portfolio_tags' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
        'show_in_rest'          => true,
    );
    register_post_type( 'portfolio', $args );

}
add_action( 'init', 'portfolio_post_type', 0 );