<?php
namespace RoboTheme\inc\elementor\Modules\Search\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Schemes;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class RBT_Search extends Widget_Base {

	public function get_name() {
		return 'rbt-search';
	}

	public function get_title() {
		return esc_html__( 'Search', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-site-search';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'search', 'find' ];
	}

	public function get_style_depends() {
		return [ 'rbt-search' ];
	}

	public function get_script_depends() {
		return [ 'rbt-search' ];
	}

	protected function register_controls() {
		$this->register_controls_content_layout();
		$this->register_controls_style_container();
		$this->register_controls_style_input();
		$this->register_controls_style_button();
		$this->register_controls_style_toggle_icon();
	}

	protected function register_controls_content_layout(){

		$this->start_controls_section(
			'section_search_layout',
			[
				'label' => esc_html__( 'Search Layout', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'skin',
			[
				'label'   => esc_html__( 'Skin', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'  => esc_html__( 'Default', TEXT_DOMAIN ),
					'dropdown'  => esc_html__( 'Dropdown', TEXT_DOMAIN ),	
				],
				'prefix_class' => 'elementor-search-form-skin-',
				'render_type'  => 'template',
			]
		); 

		$this->add_control(
			'search_query',
			[
				'label'       => esc_html__( 'Specific Post Type', TEXT_DOMAIN ),
				'description' => esc_html__( 'Select post type if you need to search only this post type content.', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 0,
				'options'     => rbt_get_post_types(),
			]
		);

		$this->add_control(
			'placeholder',
			[
				'label'     => esc_html__( 'Placeholder', TEXT_DOMAIN ),
				'type'      => Controls_Manager::TEXT,
				'dynamic'   => [ 'active' => true ],
				'separator' => 'before',
				'default'   => esc_html__( 'Search', TEXT_DOMAIN ) . '...',
			]
		);

		// search icon //
		$this->add_control(
			'show_search_icon',
			[
				'label'   => esc_html__( 'Search Icon', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'search_icon_flip',
			[
				'label'     => esc_html__( 'Icon Flip', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'show_search_icon' => 'yes',
				],
			]
		);

		$this->add_control(
			'search_icon',
			[
				'label'       => esc_html__('Choose Toggle Icon', TEXT_DOMAIN),
				'type'        => Controls_Manager::ICONS,
				'fa4compatibility' => 'toggle_icon',
				'default' => [
					'value' => 'fas fa-search',
					'library' => 'fa-solid',
				],
				'condition' => [
					'show_search_icon' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'search_align',
			[
				'label'   => esc_html__( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-search-container' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'search_width',
			[
				'label' => esc_html__( 'Search Width', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 150,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-search-container .rbt-search-default' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// search button //
        $this->add_control(
			'search_button',
			[
				'label'   => esc_html__( 'Search Button', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'condition' => [
					'search_icon_flip' => '',
				],
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'     => esc_html__( 'Button Text', TEXT_DOMAIN ),
				'type'      => Controls_Manager::TEXT,
				'dynamic'   => [ 'active' => true ],
				'default'   => esc_html__( 'Submit', TEXT_DOMAIN ),
				'condition' => [
					'search_button' => 'yes',
				],
			]
		);

		$this->add_control(
			'button_icon',
			[
				'label'            => __( 'Icon', TEXT_DOMAIN ),
				'type'             => Controls_Manager::ICONS,
				'render_type'      => 'template',
				'condition'        => [
					'search_button' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'button_position',
			[
				'label' => esc_html__( 'Button Position', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-search .rbt-search-button' => 'right: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'search_button' => 'yes',
				],
			]
		);

        $this->add_responsive_control(
			'icon_spacing',
			[
				'label' => esc_html__( 'Icon Spacing', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-search .rbt-search-button i, {{WRAPPER}} .rbt-search .rbt-search-button svg' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'search_button' => 'yes',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function register_controls_style_container(){

		$this->start_controls_section(
			'section_search_layout_style',
			[
				'label' => esc_html__( 'Search Container', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'search_container_background',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-container .rbt-search:not(.rbt-search-navbar), 
					 {{WRAPPER}} .rbt-search-container .rbt-navbar-dropdown,
					 {{WRAPPER}} .rbt-search-container .rbt-drop' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'search_container_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-search-container .rbt-search' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'search_container_margin',
			[
				'label'      => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-search-container .rbt-navbar-dropdown' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'skin' => 'dropdown'
				]
			]
		);

		$this->add_responsive_control(
			'search_container_radius',
			[
				'label'      => esc_html__( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-search-container .rbt-search:not(.rbt-search-navbar), 
					 {{WRAPPER}} .rbt-search-container .rbt-navbar-dropdown,
					 {{WRAPPER}} .rbt-search-container .rbt-drop' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'search_container_shadow',
				'selector' => '{{WRAPPER}} .rbt-search-container .rbt-search:not(.rbt-search-navbar), 
							   {{WRAPPER}} .rbt-search-container .rbt-navbar-dropdown,
					           {{WRAPPER}} .rbt-search-container .rbt-drop',
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_input() {

		$this->start_controls_section(
			'section_search_style',
			[
				'label' => esc_html__( 'Input', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'input_typography',
				'selector' => '{{WRAPPER}} .rbt-search-input, #modal-search-{{ID}} .rbt-search-input',
			]
		);

		$this->add_control(
			'search_icon_size',
			[
				'label'     => esc_html__( 'Icon Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'default' => [
					'size' => 20
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-search .rbt-search-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-search .rbt-search-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Icon Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search .rbt-search-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-search .rbt-search-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_input_colors' );

		$this->start_controls_tab(
			'tab_input_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'input_text_color',
			[
				'label'  => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-input,
					 #modal-search-{{ID}} .rbt-search-icon svg' => 'color: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'input_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-container .rbt-search .rbt-search-input' => 'background-color: {{VALUE}}',
					'#modal-search-{{ID}} .rbt-search-container .rbt-search .rbt-search-input' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'input_placeholder_color',
			[
				'label'     => esc_html__( 'Placeholder Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-input::placeholder' => 'color: {{VALUE}}',
					'#modal-search-{{ID}} .rbt-search-input::placeholder' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'input_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-input' => 'border-color: {{VALUE}}',
					'#modal-search-{{ID}} .rbt-search-input' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'input_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-search-input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'#modal-search-{{ID}} .rbt-search-input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'           => 'input_shadow',
				'selector'       => '{{WRAPPER}} .rbt-search-input',
				'fields_options' => [
					'shadow_type' => [
						'separator' => 'default',
					],
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_input_focus',
			[
				'label' => esc_html__( 'Focus', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'input_text_color_focus',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-input:focus' => 'color: {{VALUE}}',
					'#modal-search-{{ID}} .rbt-search-input:focus' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'input_background_color_focus',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-input:focus' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'input_border_color_focus',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-input:focus' => 'border-color: {{VALUE}}',
					'#modal-search-{{ID}} .rbt-search-input:focus' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'           => 'input_shadow_focus',
				'selector'       => '{{WRAPPER}} .rbt-search-input:focus',
				'fields_options' => [
					'shadow_type' => [
						'separator' => 'default',
					],
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'button_border_width',
			[
				'label'     => esc_html__( 'Border Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-input' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'#modal-search-{{ID}} .rbt-search-input' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'border_radius',
			[
				'label' => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 3,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-search-input' => 'border-radius: {{SIZE}}{{UNIT}}',
					'#modal-search-{{ID}} .rbt-search-input' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();

	}

    protected function register_controls_style_button() {

		$this->start_controls_section(
			'section_style_search_button',
			[
				'label'     => __( 'Search Button', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'search_button'       => 'yes',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_search_button_style' );

		$this->start_controls_tab(
			'tab_search_button_normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'search_button_text_color',
			[
				'label'     => __( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search .rbt-search-button' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-search .rbt-search-button svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'search_button_background',
				'selector'  => '{{WRAPPER}} .rbt-search .rbt-search-button',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'search_button_border',
				'selector'    => '{{WRAPPER}} .rbt-search .rbt-search-button'
			]
		);

		$this->add_responsive_control(
			'search_button_radius',
			[
				'label'      => __( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-search .rbt-search-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'search_button_shadow',
				'selector' => '{{WRAPPER}} .rbt-search .rbt-search-button',
			]
		);

		$this->add_responsive_control(
			'search_button_padding',
			[
				'label'      => __( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-search .rbt-search-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'search_button_typography',
				'selector' => '{{WRAPPER}} .rbt-search .rbt-search-button',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_search_button_hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'search_button_hover_text_color',
			[
				'label'     => __( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search .rbt-search-button:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-search .rbt-search-button:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'search_button_hover_background',
				'selector'  => '{{WRAPPER}} .rbt-search .rbt-search-button:hover',
			]
		);

		$this->add_control(
			'search_button_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search .rbt-search-button:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'search_button_border_border!' => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'search_button_hover_shadow',
				'selector' => '{{WRAPPER}} .rbt-search .rbt-search-button:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

	}

	protected function register_controls_style_toggle_icon() {

		$this->start_controls_section(
			'section_style_toggle_icon',
			[
				'label'     => esc_html__( 'Toggle Icon', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'skin!' => 'default'
				]
			]
		);
	
		$this->add_control(
			'toggle_icon_size',
			[
				'label'     => esc_html__( 'Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-toggle' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
	
		$this->add_control(
			'toggle_icon_color',
			[
				'label'     => esc_html__('Color', TEXT_DOMAIN),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-toggle' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-search-toggle svg' => 'fill: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'toggle_icon_background',
			[
				'label'     => esc_html__('Background', TEXT_DOMAIN),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-search-toggle' => 'background-color: {{VALUE}};'
				]
			]
		);
	
		$this->add_responsive_control(
			'toggle_icon_padding',
			[
				'label'      => esc_html__('Padding', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-search-toggle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
	
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'toggle_icon_border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-search-toggle'
			]
		);
	
		$this->add_control(
			'toggle_icon_radius',
			[
				'label'      => esc_html__('Radius', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-search-toggle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;'
				]
			]
		);
	
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'toggle_icon_shadow',
				'selector' => '{{WRAPPER}} .rbt-search-toggle'
			]
		);
	
		$this->end_controls_section();

	}

    // icon search //
	private function search_icon($settings) {

		$icon_class = ( $settings['search_icon_flip'] ) ? 'rbt-search-icon-flip' : '';

		if ( $settings['show_search_icon'] ) :

			?><span class="<?php echo esc_attr($icon_class);?> rbt-search-icon"><?php
			    Icons_Manager::render_icon( $settings['search_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
            ?></span><?php

		endif;

	}

    // button search //
	private function search_button() {
		$settings = $this->get_settings_for_display();

		if ( ! $this->get_settings( 'search_button' ) ) {
			return;
		}

		?>
		<button type="submit" class="rbt-search-button">
			<?php echo esc_html( $settings['button_text'] ); ?>
			<?php Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
		</button>
		<?php

	}

    // icon search dropdown//
	private function render_toggle_icon($settings) {
		$this->add_render_attribute( 'toggle-icon', 'class', 'rbt-search-toggle' );
		$this->add_render_attribute( 'toggle-icon', 'href', '#' );
	
		if ( ! isset( $settings['toggle_icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['toggle_icon'] = 'fas fa-search';
		}

		$migrated  = isset( $settings['__fa4_migrated']['search_icon'] );
		$is_new    = empty( $settings['toggle_icon'] ) && Icons_Manager::is_migration_allowed();

		?>
		<a <?php echo $this->get_render_attribute_string( 'toggle-icon' ); ?>>

			<?php if ( $is_new || $migrated ) :
				    Icons_Manager::render_icon( $settings['search_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
				else : ?>
					<i class="<?php echo esc_attr( $settings['toggle_icon'] ); ?>" aria-hidden="true"></i>
			<?php endif; ?>
				
		</a>
		<?php

	}

    // skin //
	private function render_skin_default($settings) {

		$this->add_render_attribute( 'search', 'class', 'rbt-search-default' ); ?>

			<form <?php echo $this->get_render_attribute_string('search'); ?>>
				<div class="rbt-position-relative">
					<?php $this->search_icon($settings); ?>
					<input <?php echo $this->get_render_attribute_string('input'); ?>>
					<?php $this->search_button(); ?>
				</div>
				
				<?php if ($settings['search_query']) : ?>
				<input name="post_type" type="hidden" value="<?php echo $settings['search_query']; ?>">
				<?php endif; ?>

			</form>
            <?php
	}

	private function render_skin_dropdown($settings) {

		$this->add_render_attribute(['dropdown' => ['class' => 'rbt-navbar-dropdown',]]);

		// search icon //
		$this->render_toggle_icon( $settings );  ?>

		<div <?php echo $this->get_render_attribute_string('dropdown'); ?>>

			<div class="rbt-grid-small rbt-flex-middle">
				
				<?php $this->render_skin_default( $settings ); ?>
					
			</div>

		</div>
		<?php
	}

	public function search_form($settings) {

		$search            = [];
		$attrs['class']    = array_merge(['rbt-search'], isset($attrs['class']) ? (array) $attrs['class'] : []);
		$search['class']   = [];
		$search['class'][] = 'rbt-search-input';

		$this->add_render_attribute(
			'input', [
				'placeholder' => $settings['placeholder'],
				'class'       => 'rbt-search-input',
				'type'        => 'search',
				'name'        => 's',
				'title'       => esc_html__( 'Search', TEXT_DOMAIN ),
				'value'       => get_search_query(),
			]
		);
		
		$this->add_render_attribute( 'search', 'class', 'rbt-search' );
		$this->add_render_attribute( 'search', 'role', 'search' );
		$this->add_render_attribute( 'search', 'method', 'get' );
		$this->add_render_attribute( 'search', 'action', esc_url( home_url( '/' ) ) );

	
		if ('default' === $settings['skin']) : ?>

            <?php $this->render_skin_default($settings); ?>
			
		<?php elseif ('dropdown' === $settings['skin']) :

			$this->render_skin_dropdown($settings);

		endif;

	}

    public function render() {
		$settings    = $this->get_settings_for_display();

		?>
		<div class="rbt-search-container">
			<?php $this->search_form($settings); ?>
		</div>
		<?php		
	}

}