<?php
namespace RoboTheme\inc\elementor\Modules\DualButton\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;
use Elementor\Core\Files\Assets\Svg\Svg_Handler;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RBT_Dual_Button extends Widget_Base {

	public function get_name() {
		return 'rbt-dual-button';
	}

	public function get_title() {
		return __( 'Dual Button', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-dual-button';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'dual', 'button', 'link', 'double' ];
	}

	public function get_style_depends() {
		return [ 'rbt-dual-button' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content_button',
			[
				'label' => __( 'Button', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'dual_button_size',
			[
				'label'   => __( 'Button Size', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'md',
				'options' => [
					'xs' => __( 'Extra Small', TEXT_DOMAIN ),
					'sm' => __( 'Small', TEXT_DOMAIN ),
					'md' => __( 'Medium', TEXT_DOMAIN ),
					'lg' => __( 'Large', TEXT_DOMAIN ),
					'xl' => __( 'Extra Large', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', TEXT_DOMAIN ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => __( 'Left', TEXT_DOMAIN ),
						'icon' => 'fas fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', TEXT_DOMAIN ),
						'icon' => 'fas fa-align-center',
					],
					'end' => [
						'title' => __( 'Right', TEXT_DOMAIN ),
						'icon' => 'fas fa-align-right',
					],
				],
				'prefix_class' => 'rbt-element-align%s-',
			]
		);

		$this->add_responsive_control(
			'button_width',
			[
				'label' => __( 'Button Width', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'max' => 100,
						'min' => 20,
					],
					'px' => [
						'max' => 1200,
						'min' => 300,
					],
				],
				'size_units' => ['%', 'px'],
				'default' => [
					'size' => 40,
					'unit' => '%',
				],
				'tablet_default' => [
					'size' => 80,
					'unit' => '%',
				],
				'mobile_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-dual-button'  => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'show_middle_text',
			[
				'label' => __( 'Middle Text', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'middle_text',
			[
				'label'       => __( 'Text', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [ 'active' => true ],
				'default'     => __( 'or', TEXT_DOMAIN ),
				'placeholder' => __( 'or', TEXT_DOMAIN ),
				'condition'   => [
					'show_middle_text' => 'yes',
				],
			]
		);

		$this->add_control(
			'dual_button_gap',
			[
				'label'   => __( 'Button Gap', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 5,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a' => 'margin-right: {{SIZE}}px;',
				],
				'condition' => [
					'show_middle_text!' => 'yes',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_button_a',
			[
				'label' => __( 'Button A', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_a_text',
			[
				'label'       => __( 'Text', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [ 'active' => true ],
				'default'     => __( 'Click Me', TEXT_DOMAIN ),
				'placeholder' => __( 'Click Me', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_a_link',
			[
				'label'       => __( 'Link', TEXT_DOMAIN ),
				'type'        => Controls_Manager::URL,
				'dynamic'     => [ 'active' => true ],
				'placeholder' => __( 'https://your-link.com', TEXT_DOMAIN ),
				'default'     => [
					'url' => '#',
				],
			]
		);

		$this->add_control(
			'add_custom_a_attributes',
			[
				'label'     => __( 'Add Custom Attributes', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'custom_a_attributes',
			[
				'label' => __( 'Custom Attributes', TEXT_DOMAIN ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'key|value', TEXT_DOMAIN ),
				'description' => sprintf( __( 'Set custom attributes for the price table button tag. Each attribute in a separate line. Separate attribute key from the value using %s character.', TEXT_DOMAIN ), '<code>|</code>' ),
				'classes' => 'elementor-control-direction-ltr',
				'condition' => ['add_custom_a_attributes' => 'yes']
			]
		);

		$this->add_control(
			'button_a_onclick',
			[
				'label' => esc_html__( 'OnClick', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'button_a_onclick_event',
			[
				'label'       => __( 'OnClick Event', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => 'myFunction()',
				'description' => sprintf( __('For details please look <a href="%s" target="_blank">here</a>'), 'https://www.w3schools.com/jsref/event_onclick.asp' ),
				'condition' => [
					'button_a_onclick' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'button_a_align',
			[
				'label'   => esc_html__( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-right',
					],
				],
			]
		);

		$this->add_control(
			'button_a_select_icon',
			[
				'label'       => __( 'Icon', TEXT_DOMAIN ),
				'type'        => Controls_Manager::ICONS,
				'fa4compatibility' => 'button_a_icon',
			]
		);

		$this->add_control(
			'button_a_icon_align',
			[
				'label'   => __( 'Icon Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'right',
				'options' => [
					'left'   => __( 'Left', TEXT_DOMAIN ),
					'right'  => __( 'Right', TEXT_DOMAIN ),
					'top'    => __( 'Top', TEXT_DOMAIN ),
					'bottom' => __( 'Bottom', TEXT_DOMAIN ),
				],
				'condition' => [
					'button_a_select_icon[value]!' => '',
				],
			]
		);

		$this->add_control(
			'button_a_icon_indent',
			[
				'label' => __( 'Icon Spacing', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
					'default' => [
						'size' => 8,
					],
				'condition' => [
					'button_a_select_icon[value]!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a .rbt-flex-align-right'  => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a .rbt-flex-align-left'   => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a .rbt-flex-align-top'    => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a .rbt-flex-align-bottom' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_button_b',
			[
				'label' => __( 'Button B', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_b_text',
			[
				'label'       => __( 'Text', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [ 'active' => true ],
				'default'     => __( 'Read More', TEXT_DOMAIN ),
				'placeholder' => __( 'Read More', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_b_link',
			[
				'label'       => __( 'Link', TEXT_DOMAIN ),
				'type'        => Controls_Manager::URL,
				'dynamic'     => [ 'active' => true ],
				'placeholder' => __( 'https://your-link.com', TEXT_DOMAIN ),
				'default'     => [
					'url' => '#',
				],
			]
		);

		$this->add_control(
			'add_custom_b_attributes',
			[
				'label'     => __( 'Add Custom Attributes', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'custom_b_attributes',
			[
				'label' => __( 'Custom Attributes', TEXT_DOMAIN ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'key|value', TEXT_DOMAIN ),
				'description' => sprintf( __( 'Set custom attributes for the price table button tag. Each attribute in a separate line. Separate attribute key from the value using %s character.', TEXT_DOMAIN ), '<code>|</code>' ),
				'classes' => 'elementor-control-direction-ltr',
				'condition' => ['add_custom_b_attributes' => 'yes']
			]
		);

		$this->add_control(
			'button_b_size',
			[
				'label'   => __( 'Button Size', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'md',
				'options' => [
					'xs' => __( 'Extra Small', TEXT_DOMAIN ),
					'sm' => __( 'Small', TEXT_DOMAIN ),
					'md' => __( 'Medium', TEXT_DOMAIN ),
					'lg' => __( 'Large', TEXT_DOMAIN ),
					'xl' => __( 'Extra Large', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'button_b_onclick',
			[
				'label' => esc_html__( 'OnClick', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'button_b_onclick_event',
			[
				'label'       => __( 'OnClick Event', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => 'myFunction()',
				'description' => sprintf( __('For details please look <a href="%s" target="_blank">here</a>'), 'https://www.w3schools.com/jsref/event_onclick.asp' ),
				'condition' => [
					'button_b_onclick' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'button_b_align',
			[
				'label'   => esc_html__( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-right',
					],
				],
			]
		);

		$this->add_control(
			'button_b_select_icon',
			[
				'label'       => __( 'Icon', TEXT_DOMAIN ),
				'type'        => Controls_Manager::ICONS,
				'fa4compatibility' => 'button_b_icon',
			]
		);

		$this->add_control(
			'button_b_icon_align',
			[
				'label'   => __( 'Icon Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'right',
				'options' => [
					'left'   => __( 'Left', TEXT_DOMAIN ),
					'right'  => __( 'Right', TEXT_DOMAIN ),
					'top'    => __( 'Top', TEXT_DOMAIN ),
					'bottom' => __( 'Bottom', TEXT_DOMAIN ),
				],
				'condition' => [
					'button_b_select_icon[value]!' => '',
				],
			]
		);

		$this->add_control(
			'button_b_icon_indent',
			[
				'label' => __( 'Icon Spacing', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
					'default' => [
						'size' => 8,
					],
				'condition' => [
					'button_b_select_icon[value]!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b .rbt-flex-align-right'  => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b .rbt-flex-align-left'   => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b .rbt-flex-align-top'    => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b .rbt-flex-align-bottom' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => __( 'Button', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_dual_button_style' );

		$this->start_controls_tab(
			'tab_dual_button_normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_border_style',
			[
				'label'   => __( 'Border Style', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none'   => __( 'None', TEXT_DOMAIN ),
					'solid'  => __( 'Solid', TEXT_DOMAIN ),
					'dotted' => __( 'Dotted', TEXT_DOMAIN ),
					'dashed' => __( 'Dashed', TEXT_DOMAIN ),
					'groove' => __( 'Groove', TEXT_DOMAIN ),
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-dual-button a' => 'border-style: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'button_border_width',
			[
				'label'      => __( 'Border Width', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => 3,
					'right'  => 3,
					'bottom' => 3,
					'left'   => 3,
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-dual-button a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'button_border_style!' => 'none'
				]
			]
		);

		$this->add_responsive_control(
			'dual_button_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-dual-button a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'dual_button_shadow',
				'selector' => '{{WRAPPER}} .rbt-dual-button a',
			]
		);

		$this->add_responsive_control(
			'dual_button_padding',
			[
				'label'      => __( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-dual-button a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'dual_button_typography',
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} .rbt-dual-button a',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_dual_button_hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'dual_button_hover_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-dual-button a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'dual_button_hover_shadow',
				'selector' => '{{WRAPPER}} .rbt-dual-button a:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_style_a',
			[
				'label' => __( 'Button A', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_a_effect',
			[
				'label'   => __( 'Effect', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'a',
				'options' => [
					'a' => __( 'Effect A', TEXT_DOMAIN ),
					'b' => __( 'Effect B', TEXT_DOMAIN ),
					'c' => __( 'Effect C', TEXT_DOMAIN ),
					'd' => __( 'Effect D', TEXT_DOMAIN ),
					'e' => __( 'Effect E', TEXT_DOMAIN ),
					'f' => __( 'Effect F', TEXT_DOMAIN ),
					'g' => __( 'Effect G', TEXT_DOMAIN ),
					'h' => __( 'Effect H', TEXT_DOMAIN ),
					'i' => __( 'Effect I', TEXT_DOMAIN ),
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_a_style' );

		$this->start_controls_tab(
			'tab_button_a_normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_a_color',
			[
				'label'     => __( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_a_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a, 
								{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a.rbt-button-effect-i .rbt-button-content-wrapper:after,
								{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a.rbt-button-effect-i .rbt-button-content-wrapper:before',
				'separator' => 'after',
			]
		);

		$this->add_responsive_control(
			'button_a_border_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_a_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#666',
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'button_border_style!' => 'none'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_a_shadow',
				'selector' => '{{WRAPPER}} .rbt-dual-button a.rbt-dual-button-a',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_a_hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_a_hover_color',
			[
				'label'     => __( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_a_hover_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a:after, 
								{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a:hover,
								{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a.rbt-button-effect-i,
								{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a.rbt-button-effect-h:after',
				'separator' => 'after',
			]
		);

		$this->add_responsive_control(
			'button_a_hover_border_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_a_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'button_border_style!' => 'none'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_a_hover_shadow',
				'selector' => '{{WRAPPER}} .rbt-dual-button a.rbt-dual-button-a:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_style_b',
			[
				'label' => __( 'Button B', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_b_effect',
			[
				'label'   => __( 'Effect', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'a',
				'options' => [
					'a' => __( 'Effect A', TEXT_DOMAIN ),
					'b' => __( 'Effect B', TEXT_DOMAIN ),
					'c' => __( 'Effect C', TEXT_DOMAIN ),
					'd' => __( 'Effect D', TEXT_DOMAIN ),
					'e' => __( 'Effect E', TEXT_DOMAIN ),
					'f' => __( 'Effect F', TEXT_DOMAIN ),
					'g' => __( 'Effect G', TEXT_DOMAIN ),
					'h' => __( 'Effect H', TEXT_DOMAIN ),
					'i' => __( 'Effect I', TEXT_DOMAIN ),
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_b_style' );

		$this->start_controls_tab(
			'tab_button_b_normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_b_color',
			[
				'label'     => __( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'button_b_background',
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b, 
							   {{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b.rbt-button-effect-i .rbt-button-content-wrapper:after, 
							   {{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b.rbt-button-effect-i .rbt-button-content-wrapper:before',
				'separator' => 'after',
			]
		);

		$this->add_responsive_control(
			'button_b_border_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_b_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#666',
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'button_border_style!' => 'none'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_b_shadow',
				'selector' => '{{WRAPPER}} .rbt-dual-button a.rbt-dual-button-b',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_b_hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_b_hover_color',
			[
				'label'     => __( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_b_hover_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b:after,
								{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b:hover, 
								{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b.rbt-button-effect-i,
								{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b.rbt-button-effect-h:after
								',
				'separator' => 'after',
			]
		);

		$this->add_responsive_control(
			'button_b__hover_border_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_b_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'button_border_style!' => 'none'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_b_hover_shadow',
				'selector' => '{{WRAPPER}} .rbt-dual-button a.rbt-dual-button-b:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_button_a_icon',
			[
				'label'     => __( 'Button A Icon', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'button_a_select_icon[value]!' => '',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_a_icon_style' );

		$this->start_controls_tab(
			'tab_button_a_icon_normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_a_icon_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a .rbt-dual-button-a-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a .rbt-dual-button-a-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_a_icon_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .rbt-button .rbt-dual-button-a-icon .rbt-button-a-icon-inner',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'button_a_icon_border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-button .rbt-dual-button-a-icon .rbt-button-a-icon-inner',
			]
		);

		$this->add_control(
			'button_a_icon_padding',
			[
				'label'      => __( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button .rbt-dual-button-a-icon .rbt-button-a-icon-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_a_icon_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button .rbt-dual-button-a-icon .rbt-button-a-icon-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_a_icon_shadow',
				'selector' => '{{WRAPPER}} .rbt-button .rbt-dual-button-a-icon .rbt-button-a-icon-inner',
			]
		);

		$this->add_responsive_control(
			'button_a_icon_size',
			[
				'label' => __( 'Icon Size', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 10,
						'max'  => 100,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .rbt-button .rbt-dual-button-a-icon .rbt-button-a-icon-inner' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_a_icon_hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_a_icon_hover_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a:hover .rbt-dual-button-a-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-a:hover .rbt-dual-button-a-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_a_icon_hover_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .rbt-button:hover .rbt-dual-button-a-icon .rbt-button-a-icon-inner',
				'separator' => 'after',
			]
		);

		$this->add_control(
			'button_a_icon_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'button_a_icon_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-button:hover .rbt-dual-button-a-icon .rbt-button-a-icon-inner' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_button_b_icon',
			[
				'label'     => __( 'Button B Icon', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'button_b_select_icon[value]!' => '',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_b_icon_style' );

		$this->start_controls_tab(
			'tab_button_b_icon_normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_b_icon_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b .rbt-dual-button-b-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b .rbt-dual-button-b-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_b_icon_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .rbt-button .rbt-dual-button-b-icon .rbt-button-b-icon-inner',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'button_b_icon_border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-button .rbt-dual-button-b-icon .rbt-button-b-icon-inner',
			]
		);

		$this->add_control(
			'button_b_icon_padding',
			[
				'label'      => __( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button .rbt-dual-button-b-icon .rbt-button-b-icon-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_b_icon_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-button .rbt-dual-button-b-icon .rbt-button-b-icon-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_b_icon_shadow',
				'selector' => '{{WRAPPER}} .rbt-button .rbt-dual-button-b-icon .rbt-button-b-icon-inner',
			]
		);

		$this->add_responsive_control(
			'button_b_icon_size',
			[
				'label' => __( 'Icon Size', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 10,
						'max'  => 100,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .rbt-button .rbt-dual-button-b-icon .rbt-button-b-icon-inner' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_b_icon_hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_b_icon_hover_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b:hover .rbt-dual-button-b-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-button-wrapper .rbt-dual-button-b:hover .rbt-dual-button-b-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_b_icon_hover_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .rbt-button:hover .rbt-dual-button-b-icon .rbt-button-b-icon-inner',
				'separator' => 'after',
			]
		);

		$this->add_control(
			'button_b_icon_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'button_b_icon_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-button:hover .rbt-dual-button-b-icon .rbt-button-b-icon-inner' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_middle_text',
			[
				'label'      => __( 'Middle Text', TEXT_DOMAIN ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'conditions' => [
					'terms' => [
						[
							'name'     => 'show_middle_text',
							'value'    => 'yes',
						],
						[
							'name'     => 'middle_text',
							'operator' => '!=',
							'value'    => '',
						],
					],
				],
			]

		);

		$this->add_control(
			'middle_text_color',
			[
				'label'     => __( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-dual-button span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'middle_text_background',
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .rbt-dual-button span',
				'separator' => 'after',
			]
		);

		$this->add_responsive_control(
			'middle_text_radius',
			[
				'label'      => __( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-dual-button span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'middle_text_shadow',
				'selector' => '{{WRAPPER}} .rbt-dual-button span',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'middle_text_typography',
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} .rbt-dual-button span',
			]
		);

		$this->end_controls_section();
	}

	public function render_text_a($settings) {

		$this->add_render_attribute( 'content-wrapper-a', 'class', 'rbt-button-content-wrapper' );

		if ( 'left' == $settings['button_a_icon_align'] or 'right' == $settings['button_a_icon_align'] ) {
			$this->add_render_attribute( 'content-wrapper-a', 'class', 'rbt-flex rbt-flex-middle' );
		}
		$this->add_render_attribute( 'content-wrapper-a', 'class', 'rbt-flex-' . $settings['button_a_align'] );

		$this->add_render_attribute( 'content-wrapper-a', 'class', ( 'top' == $settings['button_a_icon_align'] ) ? 'rbt-flex rbt-flex-column' : '' );
		$this->add_render_attribute( 'content-wrapper-a', 'class', ( 'bottom' == $settings['button_a_icon_align'] ) ? 'rbt-flex rbt-flex-column-reverse' : '' );
		$this->add_render_attribute( 'content-wrapper-a', 'data-text', esc_attr($settings['button_a_text']));

		$this->add_render_attribute( 'button-a-text', 'class', 'rbt-button-text' );

		if ( ! isset( $settings['button_a_icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['button_a_icon'] = 'fas fa-arrow-left';
		}

		$migrated  = isset( $settings['__fa4_migrated']['button_a_select_icon'] );
		$is_new    = empty( $settings['button_a_icon'] ) && Icons_Manager::is_migration_allowed();

		?>
		<div <?php echo $this->get_render_attribute_string( 'content-wrapper-a' ); ?>>
			<?php if ( ! empty( $settings['button_a_select_icon']['value'] ) ) : ?>
				<div class="rbt-button-icon rbt-dual-button-a-icon rbt-flex-align-<?php echo esc_attr($settings['button_a_icon_align']); ?>">
					<div class="rbt-button-a-icon-inner">
					
					<?php if ( $is_new || $migrated ) :
						Icons_Manager::render_icon( $settings['button_a_select_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
					else : ?>
						<i class="<?php echo esc_attr( $settings['button_a_icon'] ); ?>" aria-hidden="true"></i>
					<?php endif; ?>

					</div>
				</div>
			<?php endif; ?>
			<div <?php echo $this->get_render_attribute_string( 'button-a-text' ); ?>><?php echo wp_kses( $settings['button_a_text'], rbt_allow_tags('title') ); ?></div>
		</div>
		<?php
	}

	public function render_text_b($settings) {

		$this->add_render_attribute( 'content-wrapper-b', 'class', 'rbt-button-content-wrapper' );

		if ( 'left' == $settings['button_b_icon_align'] or 'right' == $settings['button_b_icon_align'] ) {
			$this->add_render_attribute( 'content-wrapper-b', 'class', 'rbt-flex rbt-flex-middle' );
		}
		$this->add_render_attribute( 'content-wrapper-b', 'class', 'rbt-flex-' . $settings['button_b_align'] );

		$this->add_render_attribute( 'content-wrapper-b', 'class', ( 'top' == $settings['button_b_icon_align'] ) ? 'rbt-flex rbt-flex-column' : '' );
		$this->add_render_attribute( 'content-wrapper-b', 'class', ( 'bottom' == $settings['button_b_icon_align'] ) ? 'rbt-flex rbt-flex-column-reverse' : '' );
		$this->add_render_attribute( 'content-wrapper-b', 'data-text', esc_attr($settings['button_b_text']));

		$this->add_render_attribute( 'button-b-text', 'class', 'rbt-button-text' );

		if ( ! isset( $settings['button_b_icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['button_b_icon'] = 'fas fa-arrow-right';
		}

		$migrated  = isset( $settings['__fa4_migrated']['button_b_select_icon'] );
		$is_new    = empty( $settings['button_b_icon'] ) && Icons_Manager::is_migration_allowed();

		?>
		<div <?php echo $this->get_render_attribute_string( 'content-wrapper-b' ); ?>>
			<?php if ( ! empty( $settings['button_b_select_icon']['value'] ) ) : ?>
				<div class="rbt-button-icon rbt-dual-button-b-icon rbt-flex-align-<?php echo esc_attr($settings['button_b_icon_align']); ?>">
					<div class="rbt-button-b-icon-inner">
					
					<?php if ( $is_new || $migrated ) :
						Icons_Manager::render_icon( $settings['button_b_select_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
					else : ?>
						<i class="<?php echo esc_attr( $settings['button_b_icon'] ); ?>" aria-hidden="true"></i>
					<?php endif; ?>

					</div>
				</div>
			<?php endif; ?>
			<div <?php echo $this->get_render_attribute_string( 'button-b-text' ); ?>><?php echo wp_kses( $settings['button_b_text'], rbt_allow_tags('title') ); ?></div>
		</div>
		<?php
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'rbt-dual-button rbt-button-wrapper rbt-element' );

		if ( ! empty( $settings['button_a_link']['url'] ) ) {
			$this->add_render_attribute( 'button_a', 'href', $settings['button_a_link']['url'] );

			if ( $settings['button_a_link']['is_external'] ) {
				$this->add_render_attribute( 'button_a', 'target', '_blank' );
			}

			if ( $settings['button_a_link']['nofollow'] ) {
				$this->add_render_attribute( 'button_a', 'rel', 'nofollow' );
			}
		}

		if ( ! empty( $settings['button_b_link']['url'] ) ) {
			$this->add_render_attribute( 'button_b', 'href', $settings['button_b_link']['url'] );

			if ( $settings['button_b_link']['is_external'] ) {
				$this->add_render_attribute( 'button_b', 'target', '_blank' );
			}

			if ( $settings['button_b_link']['nofollow'] ) {
				$this->add_render_attribute( 'button_b', 'rel', 'nofollow' );
			}
		}

		if ( $settings['button_a_link']['nofollow'] ) {
			$this->add_render_attribute( 'button_a', 'rel', 'nofollow' );
		}

		if ( $settings['button_b_link']['nofollow'] ) {
			$this->add_render_attribute( 'button_b', 'rel', 'nofollow' );
		}

		if ( 'yes' === $settings['button_a_onclick'] ) {
			$this->add_render_attribute( 'button_a', 'onclick', $settings['button_a_onclick_event'] );
		}

		if ( 'yes' === $settings['button_b_onclick'] ) {
			$this->add_render_attribute( 'button_b', 'onclick', $settings['button_b_onclick_event'] );
		}


		// button a //
		$this->add_render_attribute( 'button_a', 'class', 'rbt-dual-button-a rbt-button' );		
		$this->add_render_attribute( 'button_a', 'class', 'rbt-button-effect-' . esc_attr($settings['button_a_effect']) );
		$this->add_render_attribute( 'button_a', 'class', 'rbt-button-size-' . esc_attr($settings['dual_button_size']) );

		if ( $settings['add_custom_a_attributes'] and ! empty( $settings['custom_a_attributes'] ) ) {
			$attributes = explode( "\n", $settings['custom_a_attributes'] );

			$reserved_attr = [ 'href', 'target' ];

			foreach ( $attributes as $attribute ) {
				if ( ! empty( $attribute ) ) {
					$attr = explode( '|', $attribute, 2 );
					if ( ! isset( $attr[1] ) ) {
						$attr[1] = '';
					}

					if ( ! in_array( strtolower( $attr[0] ), $reserved_attr ) ) {
						$this->add_render_attribute( 'button_a', trim( $attr[0] ), trim( $attr[1] ) );
					}
				}
			}
		}


		// button b //
		$this->add_render_attribute( 'button_b', 'class', 'rbt-dual-button-b rbt-button' );		
		$this->add_render_attribute( 'button_b', 'class', 'rbt-button-effect-' . esc_attr($settings['button_b_effect']) );
		$this->add_render_attribute( 'button_b', 'class', 'rbt-button-size-' . esc_attr($settings['dual_button_size']) );	

		if ( $settings['add_custom_b_attributes'] and ! empty( $settings['custom_b_attributes'] ) ) {
			$attributes = explode( "\n", $settings['custom_b_attributes'] );

			$reserved_attr = [ 'href', 'target' ];

			foreach ( $attributes as $attribute ) {
				if ( ! empty( $attribute ) ) {
					$attr = explode( '|', $attribute, 2 );
					if ( ! isset( $attr[1] ) ) {
						$attr[1] = '';
					}

					if ( ! in_array( strtolower( $attr[0] ), $reserved_attr ) ) {
						$this->add_render_attribute( 'button_b', trim( $attr[0] ), trim( $attr[1] ) );
					}
				}
			}
		}

		?>
		<div class="rbt-element-align-wrapper">
			<div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>>
				<a <?php echo $this->get_render_attribute_string( 'button_a' ); ?>>
					<?php $this->render_text_a($settings); ?>
				</a>

				<?php if ( 'yes' === $settings['show_middle_text'] ) : ?>
					<span><?php echo esc_attr($settings['middle_text']); ?></span>
				<?php endif; ?>

				<a <?php echo $this->get_render_attribute_string( 'button_b' ); ?>>
					<?php $this->render_text_b($settings); ?>
				</a>
			</div>
		</div>
		<?php
	}

}