<?php
namespace RoboTheme\inc\elementor\Modules\AdvancedHeading\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class RBT_Advanced_Heading extends Widget_Base {

	public function get_name() {
		return 'rbt-advanced-heading';
	}

	public function get_title() {
		return __( 'Advanced Heading', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-heading';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'advanced', 'heading', 'title' ];
	}

	public function get_style_depends() {
		return [ 'rbt-advanced-heading' ];
	}

	protected function register_controls() {
		$this->register_controls_content();
		$this->register_controls_content_advanced();
		$this->register_controls_style_sub_heading();
		$this->register_controls_style_main_heading();
		$this->register_controls_style_advanced();
	}

	protected function register_controls_content() {

		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => __( 'Heading', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [ 'active' => true ],
				'placeholder' => __( 'Enter your prefix title', TEXT_DOMAIN ),
				'default'     => __( 'SUB HEADING HERE', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'main_heading',
			[
				'label'       => __( 'Main Heading', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [ 'active' => true ],
				'placeholder' => __( 'Enter your main heading here', TEXT_DOMAIN ),
				'default'     => __( 'I am Advanced Heading', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'split_main_heading',
			[
				'label'     => __( 'Split Main Heading', TEXT_DOMAIN ),
				'separator' => 'before',
				'type'      => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'split_text',
			[
				'label'       => __( 'Split Text', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [ 'active' => true ],
				'label_block' => true,
				'placeholder' => __( 'Enter your split text', TEXT_DOMAIN ),
				'default'     => __( 'Split Text', TEXT_DOMAIN ),
				'condition'   => [
					'split_main_heading' => 'yes'
				],
				'separator'	  => 'after',
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => __( 'Link', TEXT_DOMAIN ),
				'type'        => Controls_Manager::URL,
				'dynamic'     => [ 'active' => true ],
				'placeholder' => 'http://your-link.com',
			]
		);

		$this->add_control(
			'header_size',
			[
				'label'   => __( 'HTML Tag', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'options' => rbt_title_tags(),
				'default' => 'h2',
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => __( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],

			]
		);

		$this->add_control(
			'advanced_heading_visibility',
			[
				'label'     => __( 'Show Advanced Heading', TEXT_DOMAIN ),
				'separator' => 'before',
				'type'      => Controls_Manager::SWITCHER,
				'default'	=> 'yes',
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_advanced() {

		$this->start_controls_section(
			'section_content_advanced_heading',
			[
				'label' 	=> __( 'Advanced Heading', TEXT_DOMAIN ),
				'condition' => [
					'advanced_heading_visibility' => 'yes',
				],
			]
		);
		$this->add_control(
			'advanced_heading',
			[
				'label'       => __( 'Advanced Heading', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [ 'active' => true ],
				'placeholder' => __( 'Enter your advanced heading', TEXT_DOMAIN ),
				'description' => __( 'This heading will show as style as background and you can move and style many way.', TEXT_DOMAIN ),
				'default'     => esc_html__( 'Advanced Heading', TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'advanced_heading_align',
			[
				'label'   => __( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading-content' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'advanced_heading_x_position',
			[
				'label'   => __( 'X Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -800,
						'max' => 800,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-advanced-heading-pos-x: {{SIZE}}px;'
				],
			]
		);

		$this->add_responsive_control(
			'advanced_heading_y_position',
			[
				'label'   => __( 'Y Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -800,
						'max' => 800,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-advanced-heading-pos-y: {{SIZE}}px;'
				],
			]
		);

		$this->add_control(
			'advanced_heading_origin',
			[
				'label'       => __( 'Rotate Origin', TEXT_DOMAIN ),
				'description' => __( 'Origin work when you set rotate value', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'top-left',
				'options'     => rbt_position(),
			]
		);

		
		$this->add_responsive_control(
			'advanced_heading_rotate',
			[
				'label'   => __( 'Rotate', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min'  => -180,
						'max'  => 180,
						'step' => 5,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-advanced-heading-rotate: {{SIZE}}deg;'
				],
			]
		);

		$this->add_control(
			'advanced_heading_hide',
			[
				'label'       => __( 'Hide at', TEXT_DOMAIN ),
				'description' => __( 'Some cases you need to hide it because when you set heading at outer position mobile device can show wrong width in that case you can hide it at mobile or tablet device. if you set overflow hidden on section or body so you don\'t need it.', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'm',
				'options'     => [
					''  => esc_html__('Nothing', TEXT_DOMAIN),
					'm' => esc_html__('Tablet and Mobile', TEXT_DOMAIN),
					's' => esc_html__('Mobile', TEXT_DOMAIN),
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_sub_heading() {

		$this->start_controls_section(
			'section_style_sub_heading',
			[
				'label'     => __( 'Sub Heading', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'sub_heading!' => '',
				]
			]
		);

		$this->add_control(
			'sub_heading_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-sub-heading' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'sub_heading_typography',
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} .rbt-advanced-heading .rbt-sub-heading',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'sub_heading_text_shadow',
				'selector' => '{{WRAPPER}} .rbt-advanced-heading .rbt-sub-heading',
			]
		);

		$this->add_control(
			'sub_heading_style',
			[
				'label'   => __( 'Style', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					''     => esc_html__('None', TEXT_DOMAIN),
					'line' => esc_html__('Line', TEXT_DOMAIN),
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'sub_heading_style_color',
			[
				'label'     => __( 'Style Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-sub-heading .line:after' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'sub_heading_style' => 'line',
				],
			]
		);

		$this->add_responsive_control(
			'sub_heading_style_width',
			[
				'label' => __( 'Width', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 1,
						'max'  => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-sub-heading .line:after' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'sub_heading_style' => 'line',
				],
			]
		);

		$this->add_responsive_control(
			'sub_heading_style_height',
			[
				'label' => __( 'Height', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 1,
						'max'  => 48,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-sub-heading .line:after' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'sub_heading_style' => 'line',
				],
			]
		);

		$this->add_control(
			'sub_heading_style_align',
			[
				'label'   => __( 'Style Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'right',
				'options' => [
					'right'      => __( 'After', TEXT_DOMAIN ),
					'left'       => __( 'Before', TEXT_DOMAIN ),
					'left-right' => __( 'After and Before', TEXT_DOMAIN ),
					'bottom'     => __( 'Bottom', TEXT_DOMAIN ),
				],
				'condition' => [
					'sub_heading_style' => 'line',
				],
			]
		);

		$this->add_responsive_control(
			'sub_heading_style_indent',
			[
				'label'   => __( 'Style Spacing', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 8,
				],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'condition' => [
					'sub_heading_style' => 'line',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-button-icon-align-right'  => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-advanced-heading .rbt-button-icon-align-left'   => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-advanced-heading .rbt-button-icon-align-bottom' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'sub_heading_style_indent_two',
			[
				'label'   => __( 'Spacing', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 8,
				],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'condition' => [
					'sub_heading_style' => 'line',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-button-icon-align-left'  => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-advanced-heading .rbt-button-icon-align-right'   => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-advanced-heading .rbt-button-icon-align-bottom' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_main_heading() {

		$this->start_controls_section(
			'section_style_main_heading',
			[
				'label'     => __( 'Main Heading', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'main_heading!' => '',
				],
			]
		);

		$this->start_controls_tabs('tabs_style_main_heading');

		$this->start_controls_tab(
			'tab_style_normal',
			[
				'label' => esc_html__('Normal', TEXT_DOMAIN)
			]
		);

		$this->add_control(
			'main_heading_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'main_heading_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner' => 'background-color: {{VALUE}};',
				]
			]
		);

		$this->add_responsive_control(
			'main_heading_padding',
			[
				'label'      => esc_html__('Padding', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'main_heading_border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner'
			]
		);

		$this->add_control(
			'main_heading_radius',
			[
				'label'      => esc_html__('Radius', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'main_heading_shadow',
				'selector' => '{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner'
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'main_heading_text_shadow',
				'selector' => '{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner'
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'main_heading_typography',
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner',
			]
		);

		$this->add_control(
			'heading_mainh_split_text',
			[
				'label'     => __( 'Split Text', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'split_main_heading' => 'yes',
					'split_text!'        => ''
				]
			]
		);

		$this->add_control(
			'mainh_split_text_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-mainh-split-text' => 'color: {{VALUE}};',
				],
				'condition' => [
					'split_main_heading' => 'yes',
					'split_text!'        => ''
				]
			]
		);

		$this->add_control(
			'mainh_split_text_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-mainh-split-text' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'split_main_heading' => 'yes',
					'split_text!'        => ''
				]
			]
		);

		$this->add_responsive_control(
			'split_text_space',
			[
				'label'   => __( 'Split Space', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-main-heading .rbt-main-heading-inner' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					'split_main_heading' => 'yes'
				],
				'separator'   => 'after',
			]
		);

		$this->add_responsive_control(
			'mainh_split_text_padding',
			[
				'label'      => esc_html__('Padding', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-mainh-split-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'split_main_heading' => 'yes',
					'split_text!'        => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'mainh_split_text_border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-mainh-split-text',
				'condition'   => [
					'split_main_heading' => 'yes',
					'split_text!'        => ''
				]
			]
		);

		$this->add_control(
			'mainh_split_text_radius',
			[
				'label'      => esc_html__('Radius', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-mainh-split-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;'
				],
				'condition' => [
					'split_main_heading' => 'yes',
					'split_text!'        => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'      => 'mainh_split_text_shadow',
				'selector'  => '{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-mainh-split-text',
				'condition' => [
					'split_main_heading' => 'yes',
					'split_text!'        => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'mainh_split_text_typography',
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_1,
				'selector'  => '{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-mainh-split-text',
				'condition' => [
					'split_main_heading' => 'yes',
					'split_text!'        => ''
				]
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_style_advanced',
			[
				'label' => esc_html__('Advanced', TEXT_DOMAIN)
			]
		);

		$this->add_control(
			'main_heading_advanced_style_color',
			[
				'label'        => __( 'Advanced Style', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SWITCHER,
				'prefix_class' => 'rbt-ep-main-color-',
				'render_type'  => 'template',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'main_heading_advanced_color',
				'selector' => '{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-main-heading-inner'
			]
		);

		$this->add_control(
			'main_heading_link_color',
			[
				'label'     => __( 'Link Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading > a:hover .rbt-main-heading-inner' => 'color: {{VALUE}};',
				],
				'condition' => [
					'main_heading_advanced_style_color!' => 'yes'
				]
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'main_heading_style',
			[
				'label'   => __( 'Style', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					''     => esc_html__('None', TEXT_DOMAIN),
					'line' => esc_html__('Line', TEXT_DOMAIN),
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'main_heading_style_color',
			[
				'label'     => __( 'Style Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .line:after' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'main_heading_style' => 'line',
				],
			]
		);

		$this->add_responsive_control(
			'main_heading_style_width',
			[
				'label' => __( 'Width', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 1,
						'max'  => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .line:after' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'main_heading_style' => 'line',
				],
			]
		);

		$this->add_responsive_control(
			'main_heading_style_height',
			[
				'label' => __( 'Height', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 1,
						'max'  => 48,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .line:after' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'main_heading_style' => 'line',
				],
			]
		);

		$this->add_control(
			'main_heading_style_align',
			[
				'label'   => __( 'Style Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'bottom',
				'options' => [
					'right'      => __( 'After', TEXT_DOMAIN ),
					'left'       => __( 'Before', TEXT_DOMAIN ),
					'left-right' => __( 'After and Before', TEXT_DOMAIN ),
					'bottom'     => __( 'Bottom', TEXT_DOMAIN ),
				],
				'condition' => [
					'main_heading_style' => 'line',
				],
			]
		);

		$this->add_responsive_control(
			'main_heading_style_indent',
			[
				'label'   => __( 'Style Spacing', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 8,
				],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'condition' => [
					'main_heading_style' => 'line',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-button-icon-align-right'  => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-button-icon-align-left'   => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-advanced-heading .rbt-main-heading .rbt-button-icon-align-bottom' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_advanced() {

		$this->start_controls_section(
			'section_style_advanced_heading',
			[
				'label'     => __( 'Advanced Heading', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'advanced_heading!' => '',
					'advanced_heading_visibility' => 'yes',

				],
			]
		);

		$this->add_control(
			'advanced_heading_advanced_color',
			[
				'label'        => __( 'Advanced Style', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SWITCHER,
				'prefix_class' => 'rbt-ep-advanced-color-',
				'render_type'  => 'template',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'advanced_heading_advanced_color',
				'selector'  => '{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div',
				'condition' => [
					'advanced_heading_advanced_color' => 'yes',
				],
			]
		);

		$this->add_control(
			'advanced_heading_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div' => 'color: {{VALUE}};',
				],
				'condition' => [
					'advanced_heading_advanced_color!' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'advanced_heading_background_color',
			[
				'label'     => __( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'advanced_heading_advanced_color!' => 'yes',
				],
			]
		);

		$this->add_control(
			'advanced_heading_padding',
			[
				'label'      => __( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'advanced_heading_typography',
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
				'selector'  => '{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div',
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'advanced_heading_shadow',
				'selector' => '{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div',
			]
		);


		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'advanced_heading_border',
				'label'       => __( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div',
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'advanced_heading_border_radius',
			[
				'label'      => __( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'advanced_heading_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div',
			]
		);

		$this->add_control(
			'advanced_heading_opacity',
			[
				'label' => __( 'Opacity', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 0.05,
						'max'  => 1,
						'step' => 0.05,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-advanced-heading .rbt-advanced-heading-content > div' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings         = $this->get_settings_for_display();
		$id               = $this->get_id();
		$heading_html     = [];
		$advanced_heading = '';
		$sub_heading      = '';
		$main_heading     = '';
		$split_heading    = '';

		if ( empty( $settings['sub_heading'] ) and empty( $settings['advanced_heading'] ) and empty( $settings['main_heading'] ) ) {
			return;
		}

		$this->add_render_attribute( 'heading', 'class', 'rbt-heading-title' );

		// sub_heading //
		if ($settings['sub_heading']) {
			$subh_style = '';
			if ('line' === $settings['sub_heading_style']) {
				if ('left-right' === $settings['sub_heading_style_align']) {
					$subh_style = '<div class="line rbt-button-icon-align-left"></div><div class="line rbt-button-icon-align-right"></div>';
				} elseif ('bottom' === $settings['sub_heading_style_align']) {
					$subh_style = '<div class="line rbt-button-icon-align-'.$settings['sub_heading_style_align'].'"></div>';
				} else {
					$subh_style = '<div class="line rbt-button-icon-align-'.$settings['sub_heading_style_align'].'"></div>';
				}
			}

			$sub_heading = '<div class="rbt-sub-heading"><div class="rbt-sub-heading-content">'.$settings['sub_heading'].'</div>'.$subh_style.'</div> ';
		}

		// advanced_heading //
		if ($settings['advanced_heading'] && $settings['advanced_heading_visibility'] == 'yes') {

			$this->add_render_attribute(
				[
					'avd-hclass' => [
						'class' => [
							'rbt-advanced-heading-content',
							$settings['advanced_heading_hide'] ? 'rbt-visible@'. $settings['advanced_heading_hide'] : '',
						],
					],
				]
			);

			$this->add_render_attribute(
				[
					'avd-hcclass' => [
						'class' => [
							$settings['advanced_heading_origin'] ? 'rbt-transform-origin-'.$settings['advanced_heading_origin'] : '',
						],
					],
				]
			);

	   		$advanced_heading = '<div ' . $this->get_render_attribute_string( 'avd-hclass' ) . '><div ' . $this->get_render_attribute_string( 'avd-hcclass' ) . '>' .$settings['advanced_heading']. '</div></div>';
		}

		$this->add_render_attribute( 'main_heading', 'class', 'rbt-main-heading-inner' );
		$this->add_inline_editing_attributes( 'main_heading' );

		$this->add_render_attribute( 'split_heading', 'class', 'rbt-mainh-split-text' );

		// main_heading //
		if ($settings['main_heading']) :

			$mainh_style = '';

			if ('line' === $settings['main_heading_style']) {
				if ('left-right' === $settings['main_heading_style_align']) {
					$mainh_style = '<div class="line rbt-button-icon-align-left"></div><div class="line rbt-button-icon-align-right"></div>';
				} elseif ('bottom' === $settings['main_heading_style_align']) {
					$mainh_style = '<div class="line rbt-button-icon-align-'.$settings['main_heading_style_align'].'"></div>';
				} else {
					$mainh_style = '<div class="line rbt-button-icon-align-'.$settings['main_heading_style_align'].'"></div>';
				}
			}

			if ( ( 'yes' == $settings['split_main_heading'] ) and ( ! empty($settings['split_text']) ) ) {
				$split_heading = '<div '.$this->get_render_attribute_string( 'split_heading' ).'>' . $settings['split_text'] . '</div>';
			}

			$main_heading = '<div '.$this->get_render_attribute_string( 'main_heading' ).'>' . $settings['main_heading'] . '</div>';

			$main_heading = '<div class="rbt-main-heading">' . $main_heading . $split_heading . $mainh_style . '</div>';

		endif;

		if ( ! empty( $settings['link']['url'] ) ) {
			$this->add_render_attribute( 'url', 'href', $settings['link']['url'] );

			if ( $settings['link']['is_external'] ) {
				$this->add_render_attribute( 'url', 'target', '_blank' );
			}

			if ( ! empty( $settings['link']['nofollow'] ) ) {
				$this->add_render_attribute( 'url', 'rel', 'nofollow' );
			}

			$main_heading = sprintf( '<a %1$s>%2$s</a>', $this->get_render_attribute_string( 'url' ), $main_heading );
		}

		$heading_html[] = '<div id ="'.$id.'" class="rbt-advanced-heading">';

			$heading_html[] = $advanced_heading;
			$heading_html[] = $sub_heading;
			$heading_html[] = sprintf( '<%1$s %2$s>%3$s</%1$s>', $settings['header_size'], $this->get_render_attribute_string( 'heading' ), $main_heading );
		
		$heading_html[] = '</div>';

		echo implode("", $heading_html);

	}

	protected function content_template() {
		?>
		<#
		var subh_style    = '';
		var mainh_style   = '';

		view.addRenderAttribute( 'main_heading', 'class', 'rbt-main-heading-inner' );
		view.addInlineEditingAttributes( 'main_heading' );

		view.addRenderAttribute( 'split_text', 'class', 'rbt-mainh-split-text' );
		view.addInlineEditingAttributes( 'split_text' );

		view.addRenderAttribute( 'main_heading_wrapper', 'class', [ 'rbt-heading-title', 'elementor-size-' + settings.size ] );

		view.addRenderAttribute('advanced_heading_content', 'class', ['rbt-advanced-heading-content'] );

		view.addRenderAttribute('advanced_heading', 'class', 'rbt-transform-origin-' + settings.advanced_heading_origin );

		var avdh_content_print = view.getRenderAttributeString( 'advanced_heading_content' );
		var avdh_transform_print = view.getRenderAttributeString( 'advanced_heading' );

		if ( 'line' === settings.sub_heading_style ) {
			if ('left-right' === settings.sub_heading_style_align) {
				subh_style = '<div class="line rbt-button-icon-align-left"></div><div class="line rbt-button-icon-align-right"></div>';
			} else if ('bottom' === settings.sub_heading_style_align) {
				subh_style = '<div class="line rbt-button-icon-align-' + settings.sub_heading_style_align + '"></div>';
			} else {
				subh_style = '<div class="line rbt-button-icon-align-' + settings.sub_heading_style_align + '"></div>';
			}
		}

		if ( 'line' === settings.main_heading_style ) {
			if ('left-right' === settings.main_heading_style_align) {
				mainh_style = '<div class="line rbt-button-icon-align-left"></div><div class="line rbt-button-icon-align-right"></div>';
			} else if ('bottom' === settings.main_heading_style_align) {
				mainh_style = '<div class="line rbt-button-icon-align-' + settings.main_heading_style_align + '"></div>';
			} else {
				mainh_style = '<div class="line rbt-button-icon-align-' + settings.main_heading_style_align + '"></div>';
			}
		}

		#>
		<div class="rbt-advanced-heading">
			<# if ( settings.advanced_heading_visibility == 'yes' ) { #>
			<div <# print(avdh_content_print) #> >
				<div <# print(avdh_transform_print) #>>
					<# print(settings.advanced_heading) #>
				</div>
			</div>
			<# } #>
			
			<# if ( settings.sub_heading != '' ) { #>
			<div class="rbt-sub-heading">
				<div class="rbt-sub-heading-content">
					<# print(settings.sub_heading); #>
				</div>
				<# print(subh_style); #>
			</div>
			<# } #>

			<{{settings.header_size}} <# print(view.getRenderAttributeString( 'main_heading_wrapper' )) #> >
				<div class="rbt-main-heading">

					<# if ( '' !== settings.link.url ) { #>
						<a href="{{{settings.link.url}}}">
					<# } #>

						
						<div {{{view.getRenderAttributeString( 'main_heading' )}}}><# print(settings.main_heading); #></div>

						<# if ( ( 'yes' == settings.split_main_heading ) && ( '' !== (settings.split_text) ) ) { #>
							<div {{{view.getRenderAttributeString( 'split_text' )}}}><# print(settings.split_text); #></div>
						<# } #>

						<# print(mainh_style); #>
						

					<# if ( '' !== settings.link.url ) { #>
						</a>
					<# } #>

				</div>

			</{{settings.header_size}}>

		</div>
		<?php
	}

}